% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTest.R
\name{makeTest}
\alias{makeTest}
\alias{makeTestFunction}
\title{Turn a Check into a Test}
\usage{
makeTest(res)

makeTestFunction(check.fun, c.fun = NULL, env = parent.frame())
}
\arguments{
\item{res}{[\code{TRUE} | \code{character(1)}]\cr
The result of a check function: \code{TRUE} for successful checks,
and an error message as string otherwise.}

\item{check.fun}{[\code{function}]\cr
Function which checks the input. Must return \code{TRUE} on success and a string with the error message otherwise.}

\item{c.fun}{[\code{character(1)}]\cr
If not \code{NULL}, instead of calling the function \code{check.fun}, use \code{.Call} to call a C function \dQuote{c.fun} with the identical
set of parameters. The C function must be registered as a native symbol, see \code{\link[base]{.Call}}.
Useful if \code{check.fun} is just a simple wrapper.}

\item{env}{[\code{environment}]\cr
The environment of the created function. Default is the \code{\link[base]{parent.frame}}.}
}
\value{
\code{makeTest} returns \code{TRUE} if the check is successful and \code{FALSE} otherwise.
 \code{makeTestFunction} returns a \code{function}.
}
\description{
\code{makeTest} is the internal function used to evaluate the result of a
check and throw an exception if necessary.
This function is currently only a stub and just calls \code{\link[base]{isTRUE}}.
\code{makeTestFunction} can be used to automatically create an assertion
function based on a check function (see example).
}
\examples{
# Simple custom check function
checkFalse = function(x) if (!identical(x, FALSE)) "Must be FALSE" else TRUE

# Create the respective test function
testFalse = function(x) {
  res = checkFalse(x)
  makeTest(res)
}

# Alternative: Automatically create such a function
testFalse = makeTestFunction(checkFalse)
print(testFalse)
}
\seealso{
Other CustomConstructors: \code{\link{makeAssertion}},
  \code{\link{makeExpectation}}
}
