% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeExpectation.R
\name{makeExpectation}
\alias{makeExpectation}
\alias{makeExpectationFunction}
\title{Turn a Check into an Expectation}
\usage{
makeExpectation(x, res, info, label)

makeExpectationFunction(check.fun, c.fun = NULL, env = parent.frame())
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{res}{[\code{TRUE} | \code{character(1)}]\cr
The result of a check function: \code{TRUE} for successful checks,
and an error message as string otherwise.}

\item{info}{[\code{character(1)}]\cr
See \code{\link[testthat]{expect_that}}}

\item{label}{[\code{character(1)}]\cr
See \code{\link[testthat]{expect_that}}}

\item{check.fun}{[\code{function}]\cr
Function which checks the input. Must return \code{TRUE} on success and a string with the error message otherwise.}

\item{c.fun}{[\code{character(1)}]\cr
If not \code{NULL}, instead of calling the function \code{check.fun}, use \code{.Call} to call a C function \dQuote{c.fun} with the identical
set of parameters. The C function must be registered as a native symbol, see \code{\link[base]{.Call}}.
Useful if \code{check.fun} is just a simple wrapper.}

\item{env}{[\code{environment}]\cr
The environment of the created function. Default is the \code{\link[base]{parent.frame}}.}
}
\value{
\code{makeExpectation} invisibly returns the checked object.
  \code{makeExpectationFunction} returns a \code{function}.
}
\description{
\code{makeExpectation} is the internal function used to evaluate the result of a
check and turn it into an \code{\link[testthat]{expectation}}.
\code{makeExceptionFunction} can be used to automatically create an expectation
function based on a check function (see example).
}
\examples{
# Simple custom check function
checkFalse = function(x) if (!identical(x, FALSE)) "Must be FALSE" else TRUE

# Create the respective expect function
expect_false = function(x, info = NULL, label = vname(x)) {
  res = checkFalse(x)
  makeExpectation(x, res, info = info, label = label)
}

# Alternative: Automatically create such a function
expect_false = makeExpectationFunction(checkFalse)
print(expect_false)
}

