% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFactor.R
\name{checkFactor}
\alias{assertFactor}
\alias{assert_factor}
\alias{checkFactor}
\alias{expect_factor}
\alias{testFactor}
\alias{test_factor}
\title{Check if an argument is a factor}
\usage{
checkFactor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, n.levels = NULL, min.levels = NULL, max.levels = NULL,
  unique = FALSE, names = NULL)

assertFactor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, n.levels = NULL, min.levels = NULL, max.levels = NULL,
  unique = FALSE, names = NULL, .var.name = vname(x), add = NULL)

assert_factor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, n.levels = NULL, min.levels = NULL, max.levels = NULL,
  unique = FALSE, names = NULL, .var.name = vname(x), add = NULL)

testFactor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, n.levels = NULL, min.levels = NULL, max.levels = NULL,
  unique = FALSE, names = NULL)

test_factor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, n.levels = NULL, min.levels = NULL, max.levels = NULL,
  unique = FALSE, names = NULL)

expect_factor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, n.levels = NULL, min.levels = NULL, max.levels = NULL,
  unique = FALSE, names = NULL, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{levels}{[\code{character}]\cr
Vector of allowed factor levels.}

\item{ordered}{[\code{logical(1)}]\cr
Check for an ordered factor? If \code{FALSE} or \code{TRUE}, checks explicitly
for an unordered or ordered factor, respectively.
Default is \code{NA} which does not perform any additional check.}

\item{empty.levels.ok}{[\code{logical(1)}]\cr
Are empty levels allowed?
Default is \code{TRUE}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{n.levels}{[\code{integer(1)}]\cr
Exact number of factor levels.
Default is \code{NULL} (no check).}

\item{min.levels}{[\code{integer(1)}]\cr
Minimum number of factor levels.
Default is \code{NULL} (no check).}

\item{max.levels}{[\code{integer(1)}]\cr
Maximum number of factor levels.
Default is \code{NULL} (no check).}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertFactor}/\code{assert_factor}
 throws an error message, \code{testFactor}/\code{test_factor}
 returns \code{FALSE},
 and \code{checkFactor} returns a string with the error message.
 The function \code{expect_factor} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a factor
}
\examples{
x = factor("a", levels = c("a", "b"))
testFactor(x)
testFactor(x, empty.levels.ok = FALSE)
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDataTable}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNumeric}}, \code{\link{checkVector}}
}

