% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSubset.r
\name{checkSubset}
\alias{assertSubset}
\alias{assert_subset}
\alias{checkSubset}
\alias{expect_subset}
\alias{testSubset}
\alias{test_subset}
\title{Check if an argument is a subset of a given set}
\usage{
checkSubset(x, choices, empty.ok = TRUE)

assertSubset(x, choices, empty.ok = TRUE, add = NULL, .var.name = NULL)

assert_subset(x, choices, empty.ok = TRUE, add = NULL, .var.name = NULL)

testSubset(x, choices, empty.ok = TRUE)

test_subset(x, choices, empty.ok = TRUE)

expect_subset(x, choices, empty.ok = TRUE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{choices}{[\code{atomic}]\cr
Set of possible values.}

\item{empty.ok}{[\code{logical(1)}]\cr
Treat zero-length \code{x} as subset of any set \code{choices}?
Default is \code{TRUE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertSubset}/\code{assert_subset}
 throws an error message, \code{testSubset}/\code{test_subset}
 returns \code{FALSE},
 and \code{checkSubset} returns a string with the error message.
 The function \code{expect_subset} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a subset of a given set
}
\examples{
testSubset(c("a", "z"), letters)
testSubset("ab", letters)
testSubset("Species", names(iris))
}
\seealso{
Other set: \code{\link{checkChoice}},
  \code{\link{checkSetEqual}}
}

