% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkChoice.r
\name{checkChoice}
\alias{assertChoice}
\alias{checkChoice}
\alias{expect_choice}
\alias{testChoice}
\title{Check if an object is an element of a given set}
\usage{
checkChoice(x, choices)

assertChoice(x, choices, add = NULL, .var.name)

testChoice(x, choices)

expect_choice(x, choices, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{choices}{[\code{atomic}]\cr
Set of possible values.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertChoice} throws an error message,
 \code{testChoice} returns \code{FALSE}, \code{checkChoice} returns
 a string with the error message. The function \code{expect_choice} will
 return an \code{\link[testthat]{expectation}}.
}
\description{
Check if an object is an element of a given set
}
\examples{
testChoice("x", letters)
}
\seealso{
Other set: \code{\link{assertSetEqual}},
  \code{\link{checkSetEqual}},
  \code{\link{expect_set_equal}},
  \code{\link{testSetEqual}}; \code{\link{assertSubset}},
  \code{\link{checkSubset}}, \code{\link{expect_subset}},
  \code{\link{testSubset}}
}

