% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkAtomicVector}
\alias{assertAtomicVector}
\alias{checkAtomicVector}
\alias{testAtomicVector}
\title{Check that an argument is an atomic vector}
\usage{
checkAtomicVector(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)

assertAtomicVector(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL,
  .var.name)

testAtomicVector(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertAtomicVector} throws an error message,
 \code{testAtomicVector} returns \code{FALSE} and \code{checkAtomicVector} returns
 a string with the error message.
}
\description{
An atomic vector is defined slightly different from specifications in
\code{\link[base]{is.atomic}} and \code{\link[base]{is.vector}}:
An atomic vector is either \code{logical}, \code{integer}, \code{numeric},
\code{complex}, \code{character} or \code{raw} and can have any attributes.
I.e., a \code{factor} is an atomic vector, but \code{NULL} is not.
In short, this is equivalent to \code{is.atomic(x) && !is.null(x)}.
}
\examples{
testAtomicVector(letters, min.len = 1L, any.missing = FALSE)
}
\seealso{
Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{testArray}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{testAtomic}}; \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{testComplex}};
  \code{\link{assertDataFrame}},
  \code{\link{checkDataFrame}},
  \code{\link{testDataFrame}};
  \code{\link{assertEnvironment}},
  \code{\link{checkEnvironment}},
  \code{\link{testEnvironment}};
  \code{\link{assertFactor}}, \code{\link{checkFactor}},
  \code{\link{testFactor}}; \code{\link{assertFunction}},
  \code{\link{checkFunction}}, \code{\link{testFunction}};
  \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{testIntegerish}};
  \code{\link{assertInteger}}, \code{\link{checkInteger}},
  \code{\link{testInteger}}; \code{\link{assertList}},
  \code{\link{checkList}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{testLogical}}; \code{\link{assertMatrix}},
  \code{\link{checkMatrix}}, \code{\link{testMatrix}};
  \code{\link{assertNumeric}}, \code{\link{checkNumeric}},
  \code{\link{testNumeric}}; \code{\link{assertVector}},
  \code{\link{checkVector}}, \code{\link{testVector}}
}

