% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_breaks.R
\name{get_breaks}
\alias{get_breaks}
\alias{get_breaks.numeric}
\alias{get_breaks.integer64}
\title{Pretty break-points for continuous (numeric) data}
\usage{
get_breaks(x, n = 7, ...)

\method{get_breaks}{numeric}(
  x,
  n = 7,
  pretty = TRUE,
  expand_min = FALSE,
  expand_max = FALSE,
  ...
)

\method{get_breaks}{integer64}(x, n = 7, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{n}{Number of breakpoints. You may get less or more than requested.}

\item{...}{Extra arguments passed onto methods.}

\item{pretty}{Should pretty break-points be prioritised? Default is \code{TRUE}.}

\item{expand_min}{Should smallest break be extended beyond the
minimum of the data? Default is \code{FALSE}.}

\item{expand_max}{Should largest break be extended beyond the maximum
of the data? Default is \code{FALSE}.}
}
\value{
A numeric vector of break-points.
}
\description{
The distances between break-points are always equal in this implementation.
}
\examples{
library(cheapr)

set.seed(123)
ages <- sample(0:80, 100, TRUE)

get_breaks(ages, n = 10)

## To get the same break-points that `cut()` produces, we can do this..

signif(
  get_breaks(ages, n = 5, pretty = FALSE,
             expand_min = TRUE, expand_max = TRUE), 3
)
levels(cut(ages, 5))

}
