% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sset.R
\name{sset}
\alias{sset}
\alias{sset.Date}
\alias{sset.POSIXct}
\alias{sset.factor}
\alias{sset.data.frame}
\alias{sset.tbl_df}
\alias{sset.POSIXlt}
\alias{sset.data.table}
\alias{sset.sf}
\title{Cheaper subset}
\usage{
sset(x, ...)

\method{sset}{Date}(x, i, ...)

\method{sset}{POSIXct}(x, i, ...)

\method{sset}{factor}(x, i, ...)

\method{sset}{data.frame}(x, i, j = seq_along(x), ...)

\method{sset}{tbl_df}(x, i, j = seq_along(x), ...)

\method{sset}{POSIXlt}(x, i, j, ...)

\method{sset}{data.table}(x, i, j = seq_along(x), ...)

\method{sset}{sf}(x, i, j = seq_along(x), ...)
}
\arguments{
\item{x}{Vector or data frame.}

\item{...}{Further parameters passed to \code{[}.}

\item{i}{A logical or vector of indices. \cr}

\item{j}{Column indices, names or logical vector.}
}
\description{
Cheaper alternative to \code{[} that consistently subsets data frame
rows, always returning a data frame. There are explicit methods for
enhanced data frames like tibbles, data.tables and sf.
}
\details{
\code{sset} is an S3 generic.
You can either write methods for \code{sset} or \code{[}. \cr
\code{sset} will fall back on using \code{[} when no suitable method is found.

To get into more detail, using \code{sset()} on a data frame, a new
list is always allocated through \code{new_list()}.
\subsection{Difference to base R}{

When \code{i} is a logical vector, it is passed directly to \code{which_()}. \cr
This means that \code{NA} values are ignored and this also means that \code{i}
is not recycled, so it is good practice to make sure the logical vector
matches the length of x. To return \code{NA} values, use \code{x[NA_integer_]}.
}

\subsection{ALTREP range subsetting}{

When \code{i} is an ALTREP compact integer sequence which can be commonly created
using e.g. \code{1:10} or using \code{seq_len}, \code{seq_along} and \code{seq.int},
\code{sset} internally uses a range-based subsetting which is faster and doesn't
allocate \code{i} into memory.
}
}
\examples{
library(cheapr)
library(bench)

# Selecting columns
sset(airquality, j = "Temp")
sset(airquality, j = 1:2)

# Selecting rows
sset(iris, 1:5)

# Rows and columns
sset(iris, 1:5, 1:5)
sset(iris, iris$Sepal.Length > 7, c("Species", "Sepal.Length"))

# Comparison against base
x <- rnorm(10^4)

mark(x[1:10^3], sset(x, 1:10^3))
mark(x[x > 0], sset(x, x > 0))

df <- data.frame(x = x)

mark(df[df$x > 0, , drop = FALSE],
     sset(df, df$x > 0),
     check = FALSE) # Row names are different

}
