% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{get_semantic_transparency}
\alias{get_semantic_transparency}
\title{Get Semantic Transparency Rating}
\usage{
get_semantic_transparency(
  stimulus,
  model = "gpt-3.5-turbo",
  api_key = "",
  top_p = 1,
  temp = 0
)
}
\arguments{
\item{stimulus}{A character string representing the language material.}

\item{model}{A character string specifying the LLM model (default "gpt-3.5-turbo").}

\item{api_key}{API key as a character string.}

\item{top_p}{Numeric value (default 1).}

\item{temp}{Numeric value (default 0).}
}
\value{
An integer rating (1-7) indicating the semantic transparency.
}
\description{
Uses an LLM to obtain a semantic transparency rating for the given linguistic stimulus.
}
\details{
Default definition: "Semantic transparency is the degree to which the meaning of a compound or phrase
can be inferred from its constituent parts."
}
\examples{
\dontrun{
  sem_trans <- get_semantic_transparency("blackbird",
                                          model = "gpt-3.5-turbo",
                                          api_key = "your_api_key")
  cat("Semantic Transparency Rating:", sem_trans, "\n")
}
}
