% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{get_lexical_coverage}
\alias{get_lexical_coverage}
\title{Get Lexical Coverage with Specified Vocabulary}
\usage{
get_lexical_coverage(
  stimulus,
  vocab_size = 2000,
  vocab_test = "Vocabulary Levels Test",
  model = "gpt-3.5-turbo",
  api_key = "",
  top_p = 1,
  temp = 0
)
}
\arguments{
\item{stimulus}{A character string representing the language material.}

\item{vocab_size}{A numeric value indicating the size of the target vocabulary (e.g., 1000, 2000, 3000).}

\item{vocab_test}{A character string specifying the vocabulary test used (e.g., "Vocabulary Levels Test", "LexTALE").
Users may provide any test name.}

\item{model}{A character string specifying the LLM model (default "gpt-3.5-turbo").}

\item{api_key}{API key as a character string.}

\item{top_p}{Numeric value for probability mass (default 1).}

\item{temp}{Numeric value for temperature (default 0).}
}
\value{
A numeric value indicating the lexical coverage percentage.
}
\description{
Uses an LLM to obtain the lexical coverage (percentage) of a given text,
taking into account a specified vocabulary size and the vocabulary test basis.
}
\details{
Default definition: "Lexical coverage is the proportion of words in a text that are included in a given vocabulary list.
For this evaluation, assume a target vocabulary size of \code{vocab_size} words based on the \code{vocab_test}."
}
\examples{
\dontrun{
  coverage <- get_lexical_coverage("The quick brown fox jumps over the lazy dog",
                                   vocab_size = 2000,
                                   vocab_test = "Vocabulary Levels Test",
                                   model = "gpt-3.5-turbo",
                                   api_key = "your_api_key")
  cat("Lexical Coverage (\%):", coverage, "\n")
}
}
