% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{get_levenshtein_d}
\alias{get_levenshtein_d}
\title{Get Levenshtein Distance (D)}
\usage{
get_levenshtein_d(
  stimulus1,
  stimulus2,
  model = "gpt-3.5-turbo",
  api_key = "",
  top_p = 1,
  temp = 0
)
}
\arguments{
\item{stimulus1}{A character string representing the first text.}

\item{stimulus2}{A character string representing the second text.}

\item{model}{A character string specifying the LLM model (default "gpt-3.5-turbo").}

\item{api_key}{API key as a character string.}

\item{top_p}{Numeric value (default 1).}

\item{temp}{Numeric value (default 0).}
}
\value{
A numeric value representing the Levenshtein distance.
}
\description{
Uses an LLM to compute the Levenshtein distance (D) between two linguistic stimuli.
}
\details{
Default definition: "Levenshtein distance is defined as the minimum number of single-character edits
(insertions, deletions, or substitutions) required to transform one string into another."
}
\examples{
\dontrun{
  lev_dist <- get_levenshtein_d("kitten", "sitting",
                                model = "gpt-3.5-turbo",
                                api_key = "your_api_key")
  cat("Levenshtein Distance:", lev_dist, "\n")
}
}
