% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img2img_StableDiffusion4R.R
\name{img2img_StableDiffusion4R}
\alias{img2img_StableDiffusion4R}
\title{Image to Image Transformation using Stable Diffusion}
\usage{
img2img_StableDiffusion4R(
  text_prompts,
  init_image_path,
  init_image_mode = "IMAGE_STRENGTH",
  image_strength = 0.35,
  weight = 0.5,
  number_of_images = 1,
  steps = 15,
  cfg_scale = 7,
  seed = 0,
  clip_guidance_preset = "NONE",
  sampler = NULL,
  style_preset = "photographic",
  engine_id = "stable-diffusion-v1-5",
  api_host = "https://api.stability.ai",
  api_key = Sys.getenv("DreamStudio_API_KEY"),
  verbose = TRUE
)
}
\arguments{
\item{text_prompts}{A string. The text prompt to guide image transformation. Should not be empty.}

\item{init_image_path}{A string. This is the path to the image file to be used as the basis for the image to image transformation. Should be a valid PNG file.}

\item{init_image_mode}{A string. Determines whether to use 'image_strength' or 'step_schedule_*' to control the influence of the initial image. Default is 'IMAGE_STRENGTH'.}

\item{image_strength}{A numeric value. Specifies the influence of the initial image on the diffusion process. Default is 0.35.}

\item{weight}{A numeric value. Indicates the weight of the text prompt. Default is 0.5.}

\item{number_of_images}{An integer. The number of images to generate. Default is 1.}

\item{steps}{An integer. The number of diffusion steps to run. Default is 15.}

\item{cfg_scale}{A numeric value. How strictly the diffusion process adheres to the prompt text. Default is 7.}

\item{seed}{An integer. The seed for random noise generation. Default is 0.}

\item{clip_guidance_preset}{A string. A preset to guide the image model. Default is 'NONE'.}

\item{sampler}{A string. Which sampler to use for the diffusion process. If this value is omitted, an appropriate sampler will be automatically selected.}

\item{style_preset}{A string. Specifies the style preset to guide the image model towards a particular style. Default is 'photographic'.}

\item{engine_id}{A string. The engine id to be used in the API. Default is 'stable-diffusion-v1-5'.
Other possible values are 'stable-diffusion-512-v2-1', 'stable-diffusion-xl-beta-v2-2-2', 'stable-diffusion-768-v2-1'.}

\item{api_host}{A string. The host of the Stable Diffusion API. Default is 'https://api.stability.ai'.}

\item{api_key}{A string. The API key for the Stable Diffusion API. It is read from the 'DreamStudio_API_KEY' environment variable by default.}

\item{verbose}{A logical flag to print the message Default is TRUE.}
}
\value{
A list of images generated from the initial image and the text prompt.
}
\description{
This function uses the Stable Diffusion process to transform
an initial image according to given prompts.
}
\examples{
\dontrun{
text_prompts <- "Add a cat"
init_image_path <- system.file("img", "JP_castle.png", package = "chatAI4R")
images = img2img_StableDiffusion4R(text_prompts, init_image_path)
Display(images)
}
}
\author{
Satoshi Kume
}
