% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Display.R
\name{Display}
\alias{Display}
\title{Display Images and Optionally Write Them to File}
\usage{
Display(img, write_file = FALSE, Rds = FALSE, mar = 0.05, mfRow = TRUE)
}
\arguments{
\item{img}{A list. The list of images to display. Each image in the list should be of class "Image".}

\item{write_file}{A logical. Whether to write the images to .png files. Defaults to FALSE.}

\item{Rds}{A logical. Whether to save the images as .Rds files. Defaults to FALSE.}

\item{mar}{A numeric. The margin size for the plot. Defaults to 0.05.}

\item{mfRow}{A logical. Whether to use row-wise layout for multiple images. Defaults to TRUE.}
}
\value{
Invisible NULL. The function is called for its side effect of displaying images and optionally writing them to file.
}
\description{
This function displays images that are stored in a list. It also has options for saving the images to a .Rds or .png file.
}
\details{
Display Images and Optionally Write Them to File	#' Display Images and Optionally Write Them to File
}
\examples{
\dontrun{
# Create a list of images
img <- list(image1, image2, image3)

# Display the images
Display(img)

# Display the images and write them to .png files
Display(img, write_file = TRUE)

# Display the images and save them as .Rds files
Display(img, Rds = TRUE)
}
}
\author{
Satoshi Kume
}
