% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datetime-provider.R
\name{DateTimeProvider}
\alias{DateTimeProvider}
\title{DateTimeProvider}
\description{
date and time methods
}
\examples{
z <- DateTimeProvider$new()
z$countries
z$centuries
z$century()
z$timezone()
z$unix_time()
z$date("\%Y-\%M-\%d")
z$date_time()
z$year()
z$iso8601("1932-02-12 05:32:12")
# z$iso8601("January 4, 1981")

# date time between a range of dates
(start_date <- Sys.time() - 604800L)
z$date_time_between(start_date = start_date)
# in the year 1900
z$date_time_between("1900-01-01 00:00:00 PST", "1900-12-31 00:00:00 PST")
z$date_time_between("1900-01-01", "1900-12-31")
}
\references{
https://en.wikipedia.org/wiki/Unix_time

https://en.wikipedia.org/wiki/Unix_time
}
\keyword{internal}
\section{Super class}{
\code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{DateTimeProvider}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{centuries}}{(character) centuries in roman numerals}

\item{\code{countries}}{(list) countries list}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-unix_time}{\code{DateTimeProvider$unix_time()}}
\item \href{#method-date}{\code{DateTimeProvider$date()}}
\item \href{#method-date_time}{\code{DateTimeProvider$date_time()}}
\item \href{#method-date_time_fromtimestamp}{\code{DateTimeProvider$date_time_fromtimestamp()}}
\item \href{#method-iso8601}{\code{DateTimeProvider$iso8601()}}
\item \href{#method-year}{\code{DateTimeProvider$year()}}
\item \href{#method-century}{\code{DateTimeProvider$century()}}
\item \href{#method-timezone}{\code{DateTimeProvider$timezone()}}
\item \href{#method-date_time_between}{\code{DateTimeProvider$date_time_between()}}
\item \href{#method-clone}{\code{DateTimeProvider$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="bothify">}\href{../../charlatan/html/BaseProvider.html#method-bothify}{\code{charlatan::BaseProvider$bothify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale">}\href{../../charlatan/html/BaseProvider.html#method-check_locale}{\code{charlatan::BaseProvider$check_locale()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="lexify">}\href{../../charlatan/html/BaseProvider.html#method-lexify}{\code{charlatan::BaseProvider$lexify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="numerify">}\href{../../charlatan/html/BaseProvider.html#method-numerify}{\code{charlatan::BaseProvider$numerify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit">}\href{../../charlatan/html/BaseProvider.html#method-random_digit}{\code{charlatan::BaseProvider$random_digit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_not_zero}{\code{charlatan::BaseProvider$random_digit_not_zero()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero_or_empty">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_not_zero_or_empty}{\code{charlatan::BaseProvider$random_digit_not_zero_or_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_or_empty">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_or_empty}{\code{charlatan::BaseProvider$random_digit_or_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element">}\href{../../charlatan/html/BaseProvider.html#method-random_element}{\code{charlatan::BaseProvider$random_element()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element_prob">}\href{../../charlatan/html/BaseProvider.html#method-random_element_prob}{\code{charlatan::BaseProvider$random_element_prob()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_int">}\href{../../charlatan/html/BaseProvider.html#method-random_int}{\code{charlatan::BaseProvider$random_int()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_letter">}\href{../../charlatan/html/BaseProvider.html#method-random_letter}{\code{charlatan::BaseProvider$random_letter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="randomize_nb_elements">}\href{../../charlatan/html/BaseProvider.html#method-randomize_nb_elements}{\code{charlatan::BaseProvider$randomize_nb_elements()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unix_time"></a>}}
\subsection{Method \code{unix_time()}}{
Get a timestamp between January 1, 1970 and now, unless passed
explicit \code{start_date} or \code{end_date} values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$unix_time(start_date = NULL, end_date = "now")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start_date}}{start date, a valid date format}

\item{\code{end_date}}{start date, a valid date format, default: "now"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-date"></a>}}
\subsection{Method \code{date()}}{
Generate a date between January 1, 1970 and now,
with given pattern
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$date(pattern = "\%Y-\%m-\%d")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{date pattern, default: \verb{\%Y-\%m-\%d}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-date_time"></a>}}
\subsection{Method \code{date_time()}}{
Generate a date time between January 1, 1970 and now
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$date_time(tzinfo = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tzinfo}}{timezone, see \link{timezone}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-date_time_fromtimestamp"></a>}}
\subsection{Method \code{date_time_fromtimestamp()}}{
Generate a iso8601 format date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$date_time_fromtimestamp(timestamp, tzinfo = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timestamp}}{a timestamp}

\item{\code{tzinfo}}{timezone, see \link{timezone}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iso8601"></a>}}
\subsection{Method \code{iso8601()}}{
Generate a iso8601 format date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$iso8601(date, tzinfo = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{a date, in a valid date format}

\item{\code{tzinfo}}{timezone, see \link{timezone}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-year"></a>}}
\subsection{Method \code{year()}}{
generate a year
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$year()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-century"></a>}}
\subsection{Method \code{century()}}{
generate a century
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$century()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-timezone"></a>}}
\subsection{Method \code{timezone()}}{
generate a timezone
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$timezone()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-date_time_between"></a>}}
\subsection{Method \code{date_time_between()}}{
Generate a date time based on a random date between
two given dates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$date_time_between(start_date, end_date = "now", tzinfo = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start_date}}{start date, a valid date format}

\item{\code{end_date}}{start date, a valid date format, default: "now"}

\item{\code{tzinfo}}{timezone, see \link{timezone}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DateTimeProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
