% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address-provider.R
\name{AddressProvider}
\alias{AddressProvider}
\title{AddressProvider}
\description{
address methods
}
\examples{
(z <- AddressProvider$new())
z$locale
z$allowed_locales()
z$city_suffix()
z$street_suffix()
z$building_number()
z$city()
z$country()
z$street_name()
z$street_address()
z$address()
z$country()
z$country_code()
z$postcode()

# en_GB
(z <- AddressProvider$new('en_GB'))
z$locale
z$locale_data
z$locale_data$postcode_sets
z$postcode
z$postcode()
z$street_name()

# en_NZ
(z <- AddressProvider$new('en_NZ'))
z$locale
z$street_name()

# es_ES
(z <- AddressProvider$new('es_ES'))
z$locale
z$street_name()
}
\keyword{internal}
\section{Super class}{
\code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{AddressProvider}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{locale}}{(character) xxx}

\item{\code{city_prefixes}}{(character) xxx}

\item{\code{city_suffixes}}{(character) xxx}

\item{\code{street_suffixes}}{(character) xxx}

\item{\code{building_number_formats}}{(character) xxx}

\item{\code{postcode_formats}}{(character) xxx}

\item{\code{states}}{(character) xxx}

\item{\code{states_abbr}}{(character) xxx}

\item{\code{military_state_abbr}}{(character) xxx}

\item{\code{military_ship_prefix}}{(character) xxx}

\item{\code{military_apo_format}}{(character) xxx}

\item{\code{military_dpo_format}}{(character) xxx}

\item{\code{city_formats}}{(character) xxx}

\item{\code{street_name_formats}}{(character) xxx}

\item{\code{street_address_formats}}{(character) xxx}

\item{\code{address_formats}}{(character) xxx}

\item{\code{secondary_address_formats}}{(character) xxx}

\item{\code{countries}}{(character) xxx}

\item{\code{country_codes}}{(character) xxx}

\item{\code{locale_data}}{(character) xxx}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-allowed_locales}{\code{AddressProvider$allowed_locales()}}
\item \href{#method-new}{\code{AddressProvider$new()}}
\item \href{#method-city_suffix}{\code{AddressProvider$city_suffix()}}
\item \href{#method-street_suffix}{\code{AddressProvider$street_suffix()}}
\item \href{#method-building_number}{\code{AddressProvider$building_number()}}
\item \href{#method-city}{\code{AddressProvider$city()}}
\item \href{#method-street_name}{\code{AddressProvider$street_name()}}
\item \href{#method-street_address}{\code{AddressProvider$street_address()}}
\item \href{#method-postcode}{\code{AddressProvider$postcode()}}
\item \href{#method-address}{\code{AddressProvider$address()}}
\item \href{#method-country}{\code{AddressProvider$country()}}
\item \href{#method-country_code}{\code{AddressProvider$country_code()}}
\item \href{#method-clone}{\code{AddressProvider$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="bothify">}\href{../../charlatan/html/BaseProvider.html#method-bothify}{\code{charlatan::BaseProvider$bothify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale">}\href{../../charlatan/html/BaseProvider.html#method-check_locale}{\code{charlatan::BaseProvider$check_locale()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="lexify">}\href{../../charlatan/html/BaseProvider.html#method-lexify}{\code{charlatan::BaseProvider$lexify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="numerify">}\href{../../charlatan/html/BaseProvider.html#method-numerify}{\code{charlatan::BaseProvider$numerify()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit">}\href{../../charlatan/html/BaseProvider.html#method-random_digit}{\code{charlatan::BaseProvider$random_digit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_not_zero}{\code{charlatan::BaseProvider$random_digit_not_zero()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero_or_empty">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_not_zero_or_empty}{\code{charlatan::BaseProvider$random_digit_not_zero_or_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_or_empty">}\href{../../charlatan/html/BaseProvider.html#method-random_digit_or_empty}{\code{charlatan::BaseProvider$random_digit_or_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element">}\href{../../charlatan/html/BaseProvider.html#method-random_element}{\code{charlatan::BaseProvider$random_element()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element_prob">}\href{../../charlatan/html/BaseProvider.html#method-random_element_prob}{\code{charlatan::BaseProvider$random_element_prob()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_int">}\href{../../charlatan/html/BaseProvider.html#method-random_int}{\code{charlatan::BaseProvider$random_int()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_letter">}\href{../../charlatan/html/BaseProvider.html#method-random_letter}{\code{charlatan::BaseProvider$random_letter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="randomize_nb_elements">}\href{../../charlatan/html/BaseProvider.html#method-randomize_nb_elements}{\code{charlatan::BaseProvider$randomize_nb_elements()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-allowed_locales"></a>}}
\subsection{Method \code{allowed_locales()}}{
fetch the allowed locales for this provider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$allowed_locales()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{AddressProvider} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$new(locale = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{(character) the locale to use. See
\verb{$allowed_locales()} for locales supported (default: en_US)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{AddressProvider} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-city_suffix"></a>}}
\subsection{Method \code{city_suffix()}}{
city suffix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$city_suffix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-street_suffix"></a>}}
\subsection{Method \code{street_suffix()}}{
street suffix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$street_suffix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-building_number"></a>}}
\subsection{Method \code{building_number()}}{
building numeber
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$building_number()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-city"></a>}}
\subsection{Method \code{city()}}{
city
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$city()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-street_name"></a>}}
\subsection{Method \code{street_name()}}{
street name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$street_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-street_address"></a>}}
\subsection{Method \code{street_address()}}{
street address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$street_address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-postcode"></a>}}
\subsection{Method \code{postcode()}}{
postal code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$postcode()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-address"></a>}}
\subsection{Method \code{address()}}{
address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-country"></a>}}
\subsection{Method \code{country()}}{
country name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$country()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-country_code"></a>}}
\subsection{Method \code{country_code()}}{
country code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$country_code()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
