% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/futureOverlap.R
\name{futureOverlap}
\alias{futureOverlap}
\title{Calculate the ratio of future overlap of SDMs with shapefile categories}
\usage{
futureOverlap(r, futures, field, category, r.names, futures.names)
}
\arguments{
\item{r}{list of rasters of binary SDMs}

\item{futures}{List of SpatialPolygons* objects with same CRS as r}

\item{field}{The shapefile field attribute containing the features to compare (i.e., the column name).}

\item{category}{a list of the names of shapefile features to compare. If all features are to be used, input "All".}

\item{r.names}{list of character values of the names representing each raster in r}

\item{futures.names}{list of character values of the names representing each SpatialPolygons* object in futures.}
}
\value{
a matrix showing the overlap between raster names and features.
}
\description{
Calculate future overlap of SDMs with shapefile categories
}
\examples{
#create rasters
r1 <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r1)<- runif(n = (108*108))
r2 <- r1 >=0.5
r2[r2<1] <- NA
r3 <- r1 >=0.75
r3[r3<1] <- NA
# Create r
r <- list(r2, r3)
# create r.names
r.names <- c('scenario 1', 'scenario 2')
# create futures
coords <- dismo::randomPoints(r1, 3)
future <- sp::Polygon(coords)
future <- sp::SpatialPolygons(list(sp::Polygons(list(future), ID = "a")))
futures <- list(future, future)
futures.names <- list("fut1", "fut2")
# set field and category
field = "a"
category = "All"
# run function
futureOverlap(r, futures, field, category, r.names, futures.names)
}
