% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{cg_graph_backward}
\alias{cg_graph_backward}
\title{Backward Pass}
\usage{
cg_graph_backward(graph, target, index = NULL)
}
\arguments{
\item{graph}{cg_graph object, graph that is differentiated.}

\item{target}{cg_node object, node in the graph that is differentiated. Alternatively, argument \code{target} can be a character scalar denoting the name of the node in the graph that is differentiated.}

\item{index}{numerical scalar, index of the target node that is differentiated. Defaults to NULL (i.e. all elements are differentiated element-wise).}
}
\value{
None.
}
\description{
Perform a backward pass to evaluate the partial derivatives of a given target node with respect to the nodes in a graph.
}
\note{
All nodes required to compute the target node must first have been evaluated by calling \link[cgraph:cg_graph_forward]{cg_graph_forward}. The target node is only differenated with respect to those nodes on which it directly or indirectly depends.

In case the value of the target node is a vector or an array, argument \code{index} can be used to specify which element of the vector or array is differentiated.

The derivatives have the same shape as the values of the nodes. They can be retrieved via the \code{grad} data member of a \code{cg_node} object.

If the name of the target node is supplied to argument \code{target}, a linear search is performed to retrieve the node from the graph. In case multiple nodes share the same name, the last node added to the graph is retrieved. Please note that this linear search can become relatively expensive for large graphs.
}
\examples{
# Initialize a computational graph
graph <- cg_graph()

# Add an input
a <- cg_input(name = "a")

# Add a parameter
b <- cg_parameter(4, name = "b")

# Perform some operations
c <- cg_sin(a) + cg_cos(b) - cg_tan(a)

# Set a equal to 2
a$value <- 2

# Perform forward pass
cg_graph_forward(graph, c)

# Perform backward pass
cg_graph_backward(graph, c)

# Retrieve the derivative of c with respect to b
b$grad

}
\author{
Ron Triepels
}
