% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_modify.R
\name{cff_modify}
\alias{cff_modify}
\title{Modify a \code{\link{cff}} object}
\usage{
cff_modify(x, ...)
}
\arguments{
\item{x}{A \code{\link{cff}} object.}

\item{...}{Named arguments to be used for modifying \code{x}. See also \code{...}
argument in \code{\link[=cff]{cff()}}.}
}
\value{
A \code{\link{cff}} object.
}
\description{
Add new keys or modify existing ones on a \code{\link{cff}} object.
}
\details{
Keys provided in \code{...} would override the corresponding key in \code{x}.

It is possible to add additional keys not detected by \code{\link[=cff_create]{cff_create()}} using
the \code{keys} argument. A list of valid keys can be retrieved with
\code{\link[=cff_schema_keys]{cff_schema_keys()}}. Please refer to
\href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Guide to Citation File Format schema version 1.2.0}.
for additional details.
}
\examples{
x <- cff()
x

cff_validate(x)


x_mod <- cff_modify(x,
  contact = as_cff_person("A contact"),
  message = "This overwrites fields",
  title = "New Title",
  abstract = "New abstract",
  doi = "10.21105/joss.03900"
)

x_mod

cff_validate(x_mod)

}
\seealso{
This function is wrapper of \code{\link[utils:modifyList]{utils::modifyList()}}.

See \code{\link[=cff]{cff()}} for creating \code{\link{cff}} objects from scratch.

Other core functions of \CRANpkg{cffr}:
\code{\link{cff}()},
\code{\link{cff_create}()},
\code{\link{cff_validate}()}
}
\concept{core}
