% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_read_bib_text.R
\name{cff_read_bib_text}
\alias{cff_read_bib_text}
\title{Read BibTeX markup as a \code{\link{cff_ref_lst}} object}
\usage{
cff_read_bib_text(x, encoding = "UTF-8", ...)
}
\arguments{
\item{x}{A vector of \code{character} objects with the full BibTeX string.}

\item{encoding}{Encoding to be assumed for \code{x}, see \code{\link[=readLines]{readLines()}}.}

\item{...}{
  Arguments passed on to \code{\link[=cff_read_bib]{cff_read_bib}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
An object of classes \code{\link[=cff_ref_lst]{cff_ref_lst, cff}} according to the
\code{definitions.references} specified in
the \href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Citation File Format schema}.
Each element of the \code{cff_ref_lst} object would have classes
\code{\link[=cff_ref]{cff_ref, cff}}.
}
\description{
Convert a \code{\link[=character]{character}} representing a BibTeX entry to a
\code{\link{cff_ref_lst}} object.
}
\details{
This is a helper function that writes \code{x} to a \verb{*.bib} file and reads it with
\code{\link[=cff_read_bib]{cff_read_bib()}}.

This function requires \CRANpkg{bibtex} (>= 0.5.0) and uses
\code{\link[bibtex:read.bib]{bibtex::read.bib()}}.
}
\examples{
if (requireNamespace("bibtex", quietly = TRUE)) {
  x <- c(
    "@book{einstein1921,
      title        = {Relativity: The Special and the General Theory},
      author       = {Einstein, Albert},
      year         = 1920,
      publisher    = {Henry Holt and Company},
      address      = {London, United Kingdom},
      isbn         = 9781587340925
  }",
    "@misc{misc-full,
      title        = {Handing out random pamphlets in airports},
      author       = {Joe-Bob Missilany},
      year         = 1984,
      month        = oct,
      note         = {This is a full MISC entry},
      howpublished = {Handed out at O'Hare}
  }"
  )


  cff_read_bib_text(x)
}
}
\seealso{
\code{\link[=cff_read_bib]{cff_read_bib()}} for reading \verb{*.bib} files.

Other functions for working with BibTeX format:
\code{\link{as_bibentry}()},
\code{\link{cff_read}()},
\code{\link{cff_write_bib}()},
\code{\link{encoded_utf_to_latex}()}

Other functions for reading external files:
\code{\link{cff_read}()}
}
\concept{bibtex}
\concept{reading}
