% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{estimate_pt}
\alias{estimate_pt}
\title{Estimate probabilities to be in each state}
\usage{
estimate_pt(data, NAafterTmax = FALSE)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and \code{state}, associated state.}

\item{NAafterTmax}{if TRUE, return NA if t > Tmax otherwise return the state associated with Tmax (useful when individuals has different lengths)}
}
\value{
A list of two elements:
\itemize{
  \item{t: vector of time}
  \item{pt: a matrix with K (= number of states) rows and with \code{length(t)} columns containing the probabilities to be in each state at each time.}
}
}
\description{
Estimate probabilities to be in each state
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

d_JK2 <- cut_data(d_JK, 10)

# estimate probabilities
estimate_pt(d_JK2)
}
\seealso{
\link{plot.pt}
}
\author{
Cristian Preda, Quentin Grimonprez
}
