% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_oscillations.R
\name{calculate_oscillations}
\alias{calculate_oscillations}
\title{Calculate Oscillations for Ceteris Paribus Explainer}
\usage{
calculate_oscillations(x, sort = TRUE, ...)
}
\arguments{
\item{x}{a ceteris_paribus explainer produced with the `ceteris_paribus()` function}

\item{sort}{a logical value. If TRUE then rows are sorted along the oscillations}

\item{...}{other arguments}
}
\description{
Calculate Oscillations for Ceteris Paribus Explainer
}
\examples{
library("DALEX")
 \dontrun{
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartmentsTest, y = apartmentsTest$m2.price)

apartment <- apartmentsTest[1,]

cp_rf <- ceteris_paribus(explainer_rf, apartment)
calculate_oscillations(cp_rf)
}
}
