% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cetcolor.R
\name{cet_pal}
\alias{cet_pal}
\title{CET Perceptually Uniform Color Maps}
\usage{
cet_pal(n, name = "rainbow", alpha = 1)
}
\arguments{
\item{n}{A \code{numeric} value greater than one indicating how
many colors to use from the color map.}

\item{name}{A \code{string} indicating the color map to use. There
are 51 options available. Please see \code{\link{cet_color_maps}}
for more information. By default, the \code{"rainbow"} color
scheme is used.}

\item{alpha}{A \code{numeric} value between [0, 1] that indicates the level
of transparency.}
}
\value{
A \code{character} vector containing the RGB hexadecimal
representation of the requested color map.
}
\description{
Extract \code{n} RGB Hexadecimal colors from the perceptually uniform color
maps developed by \href{http://peterkovesi.com/projects/colourmaps/}{Peter Kovesi}.
}
\examples{
# Grab 8 colors from rainbow or rainbow_bgyr_35-85_c73_n256
colors = cet_pal(8)
plot(1:8, 1:8, col=colors, pch=19, cex=3, xlab="", ylab="")

# Grab 25 colors from coolwarm or diverging_bwr_40-95_c42_n256
colors = cet_pal(25, name = "coolwarm")
plot(1:25, 1:25, col=colors, pch=19, cex=3, xlab="", ylab="")

}
\references{
Peter Kovesi. Good Colour Maps: How to Design Them.
\href{https://arxiv.org/abs/1509.03700}{arXiv:1509.03700 [cs.GR] 2015}
}
