% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_path_guess.R
\name{cnt_path_guess}
\alias{cnt_path_guess}
\title{Guess polygon's centerline}
\usage{
cnt_path_guess(input, skeleton = NULL, return_geos = FALSE, ...)
}
\arguments{
\item{input}{\code{sf}, \code{sfc} or \code{SpatVector} polygons object}

\item{skeleton}{\code{NULL} (default) or \code{\link[=cnt_skeleton]{cnt_skeleton()}} output.
If \code{NULL} then polygon's skeleton would be estimated in the background
using specified parameters (see inherit params below).}

\item{return_geos}{\code{FALSE} (default). A logical flag that controls
whether the \code{geos_geometry} should be returned.}

\item{...}{
  Arguments passed on to \code{\link[=cnt_skeleton]{cnt_skeleton}}
  \describe{
    \item{\code{keep}}{numeric, proportion of points to retain (0.05-5.0; default 0.5).
See Details.}
    \item{\code{method}}{character, either \code{"voronoi"} (default) or
\code{"straight"}, or just the first letter \code{"v"} or \code{"s"}.
See Details.}
  }}
}
\value{
An \code{sf}, \code{sfc} or \code{SpatVector} class
object of a \code{LINESTRING} geometry
}
\description{
This function, as follows from the title, tries to guess
the polygon centerline by connecting the most distant
points from each other. First, it finds the point most
distant from the polygon's centroid, then it searches
for a second point, which is most distant from the first.
The line connecting these two points will be the desired
centerline.
}
\examples{
library(sf)
library(geos)
lake <-
  sf::st_read(
    system.file("extdata/example.gpkg", package = "centerline"),
    layer = "lake",
    quiet = TRUE
  ) |>
  geos::as_geos_geometry()
# Find lake's centerline
lake_centerline <- cnt_path_guess(input = lake, keep = 1)
# Plot
plot(lake)
plot(lake_centerline, col = "firebrick", lwd = 2, add = TRUE)

}
