% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{censusGeography}
\alias{censusGeography}
\title{Census Geography}
\usage{
censusGeography(dataset, type = c("city", "stateFIP", "stateICP", "region",
  "birthplace"))
}
\arguments{
\item{dataset}{Enter a list, dataframe, or single number, that is the code for a geographic
area from the United States Census}

\item{type}{Choose which geographic level the code is connected with. Options are
city, state FIP code, state ICP code, region, and birthplace.}
}
\value{
Dataframe of two columns. The first column is the name of the location,
the second column is the location code (same as the input). If no match,
will return NA as location name
}
\description{
Census Geography
}
\examples{
census_city_codes <- c(210, 2489, 5350, 1330)
censusGeography(census_city_codes, type = "city")

# Input can be character type too
census_city_codes <- c("210", "2489", "5350", "1330")
censusGeography(census_city_codes, type = "city")

censusGeography(42, type = "region")

# If no match is found, will return NA for location name
censusGeography(0, type = "region")

census_stateFIP_code <- data.frame(c(1,2,4), c("test", "test2", "test3"))
names(census_stateFIP_code) <- c("code", "character_type_column")
censusGeography(census_stateFIP_code$code, type = "stateFIP")

}

