% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{PI}
\alias{PI}
\title{The plug-in bandwidth selection for weighted data}
\usage{
PI(X, wt, ktype = "normal")
}
\arguments{
\item{X}{The numeric vector of random variable.}

\item{wt}{The non-negative weight vector.}

\item{ktype}{A character string giving the type kernel to be used: "\code{normal}", "\code{epanechnikov}", "\code{biweight}", or "\code{triweight}". By default, the "\code{normal}" kernel is used.}
}
\value{
Returns the computed value for the bandwith parameter.
}
\description{
This function computes the data-driven bandwidth for smoothing the ROC (or distribution) function using the PI method of Beyene and El Ghouch (2019). This is an extension of the classical (unweighted) direct plug-in bandwith selection method to the case of weighted data.
}
\details{
See Beyene and El Ghouch (2019) for details.
}
\examples{
library(cenROC)

X <- rnorm(100) # random data vector
wt <- runif(100) # weight vector

## Plug-in bandwidth selection
PI(X = X, wt = wt)$bw

}
\references{
Beyene, K. M. and El Ghouch A. (2019). Smoothed time-dependent ROC curves for right-censored survival data. <\url{https://dial.uclouvain.be/pr/boreal/object/boreal:219643}>.
}
\author{
Kassu Mehari Beyene, Catholic University of Louvain. \code{<kasu.beyene@uclouvain.be>}

Anouar El Ghouch, Catholic University of Louvain. \code{<anouar.elghouch@uclouvain.be>}
}
