% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster-functions.R
\name{clusterTracks}
\alias{clusterTracks}
\title{Cluster Tracks}
\usage{
clusterTracks(
  tracks,
  measures,
  scale = TRUE,
  labels = NULL,
  method = "hclust",
  return.clust = FALSE,
  ...
)
}
\arguments{
\item{tracks}{the tracks that are to be clustered.}

\item{measures}{a function, or a vector of functions (see \link{TrackMeasures}).
Each function is expected to
return a single number given a single track.}

\item{scale}{logical indicating whether the measures values shall be scaled
using the function \code{\link[base]{scale}} before the clustering.}

\item{labels}{optional: a vector of labels of the same length as the track object.
These are used to color points in the visualization.}

\item{method}{\code{"hclust"} for hierarchical clustering, or
\code{"kmeans"} for k-means clustering.}

\item{return.clust}{logical: return the clustering object instead of only the plot?
(defaults to \code{FALSE}).}

\item{...}{additional parameters to be passed to the corresponding clustering
function: \code{\link[stats]{hclust}} or  \code{\link[stats]{kmeans}}.}
}
\value{
By default, only returns a plot. If \code{return.clust=TRUE}, also returns
a clustering object as returned by \code{\link[stats]{hclust}} or  \code{\link[stats]{kmeans}}.
  output object.
}
\description{
Perform a quick clustering visualization of a set of tracks according to a given vector
of track measures.
}
\details{
The measures are applied to each of the tracks in the given
\emph{tracks} object. According to the resulting values, the tracks are
clustered using the chosen clustering method.
If \code{scale} is \code{TRUE}, the measure values are scaled to mean value
\eqn{0} and standard deviation \eqn{1} (per measure) before the clustering.

Method hclust plots a dendrogram of the clustering.

Method kmeans plots each computed cluster (x-axis) versus each of the track
measures in the \code{measures} vector, producing one panel per measure.
If labels are given, points are colored according to their "true" label.
}
\examples{
## Cluster tracks according to the mean of their Hust exponents along X and Y
## using hierarchical clustering

cells <- c(TCells,Neutrophils)
real.celltype <- rep(c("T","N"),c(length(TCells),length(Neutrophils)))
## Prefix each track ID with its cell class to evaluate the clustering visually
names(cells) <- paste0(real.celltype,seq_along(cells))
clust <- clusterTracks( cells, hurstExponent, method = "hclust",
 return.clust = TRUE  )

## How many cells are "correctly" clustered?
sum( real.celltype == c("T","N")[cutree(clust,2)] )

}
\seealso{
\code{\link{getFeatureMatrix}} to obtain a feature matrix that can be
used for manual clustering and plotting, and \code{\link{trackFeatureMap}} to
visualize high-dimensional track feature data via dimensionality reduction.
}
