% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{knn_refine}
\alias{knn_refine}
\title{Refine cell type labels with knn classifier}
\usage{
knn_refine(labels, neighbors, min_knn_prob = 0.5)
}
\arguments{
\item{labels}{Cell type labels as character or factor.}

\item{neighbors}{Neighbor graph, pass \code{obj$neighbors}.}

\item{min_knn_prob}{Value between 0 and 1, defaults to 0.5.
If the 'winning label' is below this proportion of kNN that have it,
knn_refine will return "Unassigned".}
}
\value{
Character vector with refined labels.
}
\description{
Assigns the label that most neighbors have, given it is more than
\code{min_knn_prob}.
I've found empirically on the MALT data that \code{min_knn_prob=0.5} gives
good results, whether you classify the entire data set or just a single
cell type.
It simply excludes some of the cells that have more than 2 cell types in their
neighborhood and none is much stronger than the others,
so this is a reasonable, conservative filtering.
}
