#' @title Conditional Distance Correlation Based Feature Screening and Conditional Independence Inference
#' 
#' @description Conditional distance correlation <doi:10.1080/01621459.2014.993081> is a novel conditional dependence measurement of two multivariate random variables given a confounding variable. 
#' This package provides conditional distance correlation, performs the conditional distance correlation sure independence screening procedure for ultrahigh dimensional data <doi:10.5705/ss.202014.0117>, 
#' and conducts conditional distance covariance test for conditional independence assumption of two multivariate variable.
#' 
#' @name cdcsis-package
#' @docType package
#' @author Wenhao Hu, Mian Huang, Wenliang Pan, Xueqin Wang, Canhong Wen, Yuan Tian, Heping Zhang, Jin Zhu
#' Maintainer: Jin Zhu <zhuj37@@mail2.sysu.edu.cn>
#' @references Wang, X., Pan, W., Hu, W., Tian, Y. and Zhang, H., 2015. Conditional distance correlation. Journal of the American Statistical Association, 110(512), pp.1726-1734.
#' @references Wen, C., Pan, W., Huang, M. and Wang, X., 2018. Sure independence screening adjusted for confounding covariates with ultrahigh-dimensional data. Statistica Sinica, 28, pp.293-317.
#' @keywords SIS, conditional distance correlation, confounder
NULL