% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.ccrsdata.R
\name{create.ccrsdata}
\alias{create.ccrsdata}
\title{Create a dataset for CCRS}
\usage{
create.ccrsdata(X,q=q)
}
\arguments{
\item{X}{An n by m categorical data matrix.}

\item{q}{An integer indicating the maximum rating.}
}
\value{
Returns a list with the following elements.
\item{\code{Fmat}}{An n by q-1 matrix of scaled rank-ordered boundary data.}
\item{\code{Mmat.q1}}{A q-1 by 3+1 matrix of I-spline basis functions, evaluated at the boundaries. +1 indicates all 0 intercepts.}
\item{\code{Mmat.q}}{A q by 3+1 matrix of I-spline basis functions, evaluated at the midpoints between boundaries.}
\item{\code{X}}{An n by m categorical data matrix same as the input \code{X}.}
}
\description{
Creates a dataset for CCRS from a preference data matrix.
}
\details{
For the difference between Mmat.q and Mmat.q1 in the resulting list, see Section 3.2 in reference paper.
}
\references{
Takagishi, M., Velden, M. van de & Yadohisa, H. (2019). Clustering preference data in the presence of response style bias, to appear in British Journal of Mathematical and Statistical Psychology.
}
\seealso{
\code{\link{correct.rs}}
}
