% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccrs.R
\name{ccrs}
\alias{ccrs}
\title{Correcting and Clustering response style biased data}
\usage{
ccrs(ccrsdata.list,K=K,lam=lam, tandem.initial=FALSE,
            tol = 1e-5, maxit = 50, trace = 1, nstart = 3, parallel=F,verbose=T)
}
\arguments{
\item{ccrsdata.list}{A list generated by \code{create.ccrsdata}.}

\item{K}{An integer indicating the number of content-based clusters used for CCRS estimation.}

\item{lam}{A numeric value indicating \code{lambda} used for CCRS estimation.}

\item{tandem.initial}{A logical value indicating whether the 1st initial value is generated by CCRS tandem initialization. See Section 3.3 in the paper for the detail.}

\item{tol}{A numeric value indicating the absolute convergence tolerance}

\item{maxit}{An integer indicating the maximum number of iterations}

\item{trace}{An non-negative integer. If positive, tracing information on the progress of the optimization is produced. Higher values produce more tracing information.}

\item{nstart}{An integer indicating the number of random initial values.}

\item{parallel}{A logical value indicating parallelization over starts is used.}

\item{verbose}{A logical value indicaitng if the progress is printed during the iteration (only when \code{parallel==FALSE}).}
}
\value{
Returns a list with the following elements.
\item{\code{G}}{A K by m matrix of content-based cluster centroid.}
\item{\code{cls.cont.vec}}{A vector of integers (from 1:K) indicating the content-based cluster to which each respondent is allocated.}
\item{\code{opt.obval}}{An optimal value of objective function.}
\item{\code{crs.list}}{A list of class \code{crs}, same as the one generated by \link{correct.rs}.}
}
\description{
Applies CCRS to \code{ccrsdata.list}.
}
\examples{
###data setting
n <- 30 ; m <- 10 ; H.true <- 2 ; K.true <- 2 ; q <- 5
datagene <- generate.rsdata(n=n,m=m,K.true=K.true,H.true=H.true,q=q,clustered.rs = TRUE)
###obtain n x m data matrix
X <- datagene$X
ccrsdata.list <- create.ccrsdata(X,q=q)
###CCRS
lam <- 0.8 ; K <- 2
ccrs.list <- ccrs(ccrsdata.list,K=K,lam=lam)
###check content-based clustering result
ccrs.list$cls.cont.vec
###check correction result
plot(ccrs.list$crs.list)
}
\references{
Takagishi, M., Velden, M. van de & Yadohisa, H. (2019). Clustering preference data in the presence of response style bias, to appear in British Journal of Mathematical and Statistical Psychology.
}
\seealso{
\code{\link{correct.rs}}
}
