% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_cpts.R
\name{match.cpt.ts}
\alias{match.cpt.ts}
\title{Associating the change-points with the component time series}
\usage{
match.cpt.ts(
  X,
  cpt,
  thr_const = 1,
  thr_fin = thr_const * sqrt(2 * log(nrow(X))),
  scales = -1,
  count = 5
)
}
\arguments{
\item{X}{A numerical matrix representing the multivariate periodograms.
Each column contains a different periodogram which is the result of
applying the wavelet transformation to the initial multivariate time
series.}

\item{cpt}{A positive integer vector with the locations of the
change-points. If missing, then our approach with the \eqn{L_2}
aggregation is called internally to extract the change-points in
\code{X}.}

\item{thr_const}{A positive real number with default value equal to 1. It is
used to define the threshold; see \code{thr_fin}.}

\item{thr_fin}{With \code{T} the length of the data sequence, this is a
positive real number with default value equal to
\code{thr_const * log(T)}. It is the threshold, which is used in the
detection process.}

\item{scales}{Negative integers for the wavelet scales used to create the periodograms,
with a small negative integer representing a fine scale. The default value is equal
to -1.}

\item{count}{Positive integer with default value equal to 5. It can be used
so that the function will return only the \code{count} most important
matches of each change-points with the time series.}
}
\value{
A list with the following components:
  \tabular{ll}{
   \cr \code{time_series_indicator} \tab A list of matrices. There are as many matrices as
   \cr \tab the number of change-points. Each change-point has its own matrix, with
   \cr \tab each row of the matrix representing the associated combination of time
   \cr \tab series that are associated with the respective change-point.
   \cr \code{most_important} \tab A list of matrices. There are as many matrices as
   \cr \tab the number of change-points. Each change-point has its own matrix, with
   \cr \tab each row of the matrix representing the associated combination of time
   \cr \tab series that are associated with the respective change-point. It shows the
   \cr \tab \code{count} most important time series combinations for each change-point.
 }
}
\description{
This function performs a contrast function based approach in order to
match each change-point and time series. In simple terms, for a given
change-point set this function associates each change-point with the
respective data sequence (or sequences) from which it was detected.
}
\examples{
  set.seed(1)
  num.nodes <- 40 # number of nodes
  etaA.1    <- 0.95
  etaA.2    <- 0.05
  pcor1     <- GeneNet::ggm.simulate.pcor(num.nodes, etaA = etaA.1)
  pcor2     <- GeneNet::ggm.simulate.pcor(num.nodes, etaA = etaA.2)

  n <- 100
  data1 <- GeneNet::ggm.simulate.data(n, pcor1)
  data2 <- GeneNet::ggm.simulate.data(n, pcor2)
  X <- rbind(data1, data2, data1, data2) ## change-points at 100, 200, 300
  sgn <- sign(stats::cor(X))
  M1 <- match.cpt.ts(t(hdbinseg::gen.input(x = t(X),scales = -1, sq = TRUE,
  diag = FALSE, sgn = sgn)))
  M1
}
\references{
``Cross-covariance isolate detect: a new change-point method
  for estimating dynamic functional connectivity'', Anastasiou et al (2020),
  preprint <doi:10.1101/2020.12.20.423696>.
}
\author{
Andreas Anastasiou, \email{anastasiou.andreas@ucy.ac.cy}
}
