% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alcohol.R
\name{low_drink_long_fun}
\alias{low_drink_long_fun}
\title{Long term risks due to drinking}
\usage{
low_drink_long_fun(
  DHH_SEX,
  ALWDWKY,
  ALC_1,
  ALW_1,
  ALW_2A1,
  ALW_2A2,
  ALW_2A3,
  ALW_2A4,
  ALW_2A5,
  ALW_2A6,
  ALW_2A7
)
}
\arguments{
\item{DHH_SEX}{Sex of respondent (1 - male, 2 - female)}

\item{ALWDWKY}{Number of drinks consumed in the past week}

\item{ALC_1}{Drinks in the past year (1 - yes, 2 - no)}

\item{ALW_1}{Drinks in the last week (1 - yes, 2 - no)}

\item{ALW_2A1}{Number of drinks on Sunday}

\item{ALW_2A2}{Number of drinks on Monday}

\item{ALW_2A3}{Number of drinks on Tuesday}

\item{ALW_2A4}{Number of drinks on Wednesday}

\item{ALW_2A5}{Number of drinks on Thursday}

\item{ALW_2A6}{Number of drinks on Friday}

\item{ALW_2A7}{Number of drinks on Saturday}
}
\value{
Categorical variable (ALWDVLTR_der) with two categories:

 \itemize{
  \item 1 - Increased long term health risk
  \item 2 - No increased long term health risk
 }
}
\description{
This function creates a categorical variable that
 flags for increased long term health risks due to their drinking habits,
 according to Canada's Low-Risk Alcohol Drinking Guideline.
}
\details{
The classification of drinkers according to their long term health 
risks comes from guidelines in Alcohol and Health in Canada: A Summary of 
Evidence and Guidelines for Low-risk Drinking, and is based on the alcohol 
consumption reported over the past week. Short-term or acute risks include 
injury and overdose.

Categories are based on CCHS 2015-2016's variable (ALWDVLTR) where long 
term health risk are increased when drinking more than 10 drinks a week for 
women, with no more than 2 drinks a day most days, and more than 15 drinks a 
week for men, with no more than 3 drinks a day most days.

See \url{https://osf.io/ykau5/} for more details on the guideline. 
See \url{https://osf.io/ycxaq/} for more details on the derivation of the 
function on page 8.
}
\examples{
 
# Using low_drink_long_fun() to create ALWDVLTR_der values across CCHS cycles
# low_drink_long_fun() is specified in variable_details.csv along with the
# CCHS variables and cycles included.

# To transform ALWDVLTR_der, use rec_with_table() for each CCHS cycle
# and specify ALWDVLTR_der, along with the various alcohol and sex
# variables. 
# Using merge_rec_data(), you can combine ALWDVLTR_der across cycles.

library(cchsflow)
long_low_drink2001 <- rec_with_table(
  cchs2001_p, c(
    "ALW_1", "DHH_SEX", "ALW_2A1", "ALW_2A2", "ALW_2A3", "ALW_2A4",
    "ALW_2A5", "ALW_2A6", "ALW_2A7", "ALWDWKY", "ALC_1","ALWDVLTR_der"
  )
)

head(long_low_drink2001)

long_low_drink2009_2010 <- rec_with_table(
  cchs2009_2010_p, c(
    "ALW_1", "DHH_SEX", "ALW_2A1", "ALW_2A2", "ALW_2A3", "ALW_2A4",
    "ALW_2A5", "ALW_2A6", "ALW_2A7", "ALWDWKY", "ALC_1","ALWDVLTR_der"
  )
)

tail(long_low_drink2009_2010)

combined_long_low_drink <- bind_rows(long_low_drink2001, 
long_low_drink2009_2010)

head(combined_long_low_drink)

tail(combined_long_low_drink)

# Using low_drink_long_fun() to generate ALWDVLTR_der with user-inputted
# values.
#
# Let's say you are a male, you had drinks in the last week and in the last 
# year. Let's say you had 5 drinks on Sunday, 1 drink on Monday, 6 drinks on 
# Tuesday, 4 drinks on Wednesday, 4 drinks on Thursday, 8 drinks on Friday, 
# and 2 drinks on Saturday with a total of 30 drinks in a week. 
# Using low_drink_long_fun(), we can check if you would be classified as
# having an increased long term health risk due to drinking.

long_term_drink <- low_drink_long_fun(DHH_SEX = 1, ALWDWKY = 30, ALC_1 = 1,
 ALW_1 = 1, ALW_2A1 = 5, ALW_2A2 = 1, ALW_2A3 = 6, ALW_2A4 = 4, ALW_2A5 = 4, 
 ALW_2A6 = 8, ALW_2A7 = 2)

print(long_term_drink)
}
