% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoking.R
\name{time_quit_smoking_fun}
\alias{time_quit_smoking_fun}
\title{Time since quit smoking}
\usage{
time_quit_smoking_fun(SMK_09A_B, SMKG09C)
}
\arguments{
\item{SMK_09A_B}{number of years since quitting smoking. Variable asked to
former daily smokers who quit <3 years ago.}

\item{SMKG09C}{number of years since quitting smoking. Variable asked to
former daily smokers who quit >=3 years ago.}
}
\value{
value for time since quit smoking in time_quit_smoking_der.
}
\description{
This function creates a derived variable (time_quit_smoking_der)
 that calculates the approximate time a former smoker has quit smoking based
 on various CCHS smoking variables. This variable is for CCHS respondents in
 CCHS surveys 2003-2014.
}
\examples{
# Using time_quit_smoking_fun() to create pack-years values across CCHS 
# cycles.
# time_quit_smoking_fun() is specified in variable_details.csv along with the
# CCHS variables and cycles included.

# To transform time_quit_fun across cycles, use rec_with_table() for each
# CCHS cycle and specify time_quit_fun, along with each smoking variable.
# Then by using merge_rec_data(), you can combine time_quit_fun across cycles

library(cchsflow)

time_quit2009_2010 <- rec_with_table(
  cchs2009_2010_p, c(
    "SMK_09A_B", "SMKG09C", "time_quit_smoking_der."
  )
)

head(time_quit2009_2010)

time_quit2011_2012 <- rec_with_table(
  cchs2011_2012_p, c(
    "SMK_09A_B", "SMKG09C", "time_quit_smoking_der."
  )
)

tail(time_quit2011_2012)

combined_time_quit <- suppressWarnings(merge_rec_data(time_quit2009_2010,
 time_quit2011_2012))

head(combined_time_quit)
tail(combined_time_quit)
}
