% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-utils.R
\name{set_data_labels}
\alias{set_data_labels}
\title{Set Data Labels}
\usage{
set_data_labels(data_to_label, variable_details, variables_sheet = NULL)
}
\arguments{
\item{data_to_label}{newly transformed dataset}

\item{variable_details}{variable_details.csv}

\item{variables_sheet}{variables.csv}
}
\value{
labeled data_to_label
}
\description{
sets labels for passed database, Uses the names of final
variables in variable_details/variables_sheet as well as the labels contained
in the passed dataframes
}
\examples{
library(cchsflow)
library(sjlabelled)
bmi2001 <- rec_with_table(
 cchs2001_p, c(
    "HWTGHTM",
    "HWTGWTK", "HWTGBMI_der"
  )
)

bmi2003 <- rec_with_table(
  cchs2003_p, c(
    "HWTGHTM",
    "HWTGWTK", "HWTGBMI_der"
  )
)

combined_bmi <- bind_rows(bmi2001, bmi2003)

get_label(combined_bmi)

labeled_combined_data <- set_data_labels(combined_bmi,
 variable_details,
 variables)

get_label(labeled_combined_data)
}
