% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respiratory-condition.R
\name{COPD_Emph_der_fun1}
\alias{COPD_Emph_der_fun1}
\title{COPD_Emph_der_fun1}
\usage{
COPD_Emph_der_fun1(DHHGAGE_cont, CCC_91E, CCC_91F)
}
\arguments{
\item{DHHGAGE_cont}{continuous age variable.}

\item{CCC_91E}{variable indicating if respondent has Emphysema}

\item{CCC_91F}{variable indicating if respondent has COPD}
}
\value{
a categorical variable (COPD_Emph_der) with 3 levels:

 \enumerate{
 \item respondent is over the age of 35 and has a respiratory condition
 \item respondent is under the age of 35 and has a respiratory condition
 \item respondent does not have a respiratory condition
 }
}
\description{
This is one of 2 functions used to create a derived variable
 (COPD_Emph_der) that determines if a respondents has either COPD or 
 Emphysema. 2 different functions have been created to account for the fact
 that different respiratory variables are used across CCHS cycles. This
 function is for CCHS cycles (2005-2008) that use COPD and Emphysema as
 a combined variable.
}
\examples{
# COPD_Emph_der_fun1() to create values across CCHS cycles
# (2005-2008) COPD_Emph_der_fun1() is specified in
# variable_details.csv along with the CCHS variables and cycles included.

# To transform COPD_Emph_der, use rec_with_table() for each CCHS cycle
# and specify COPD_Emph_der, along with the various respiratory
# variables. Then by using merge_rec_data() you can combine COPD_Emph_der
# across cycles.

library(cchsflow)

COPD2005 <- suppressWarnings(rec_with_table(
  cchs2005_p,  c(
    "DHHGAGE_cont", "CCC_91E", "CCC_91F",
    "COPD_Emph_der"
  )
))

head(COPD2005)

COPD2007_2008 <- suppressWarnings(rec_with_table(
  cchs2007_2008_p, c(
    "DHHGAGE_cont", "CCC_91E", "CCC_91F", 
    "COPD_Emph_der"
  )
))

tail(COPD2007_2008)

combined_COPD <- suppressWarnings(merge_rec_data(COPD2005, COPD2007_2008))

head(combined_COPD)
tail(combined_COPD)
}
\seealso{
\code{\link{COPD_Emph_der_fun2}}
}
