% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R
\name{test.CFA}
\alias{test.CFA}
\title{test.CFA}
\usage{
test.CFA(cfaobj, fun, allt, se = T, ...)
}
\arguments{
\item{cfaobj}{a CFA object}

\item{fun}{which function to use}

\item{allt}{all values of t in the dataset}

\item{se}{whether or not to compute standard errors}

\item{...}{additional parameters for the function fun}
}
\value{
CFASE object
}
\description{
test if a counterfactual distribution is equal to its average
 for all values of the treatment
}
\examples{
\dontrun{
data(igm)
tvals <- seq(10,12,length.out=8)
yvals <- seq(quantile(igm$lcfincome, .05), quantile(igm$lcfincome, .95), length.out=50)

## obtain counterfactual results
out <- cfa2(lcfincome ~ lfincome, tvals, yvals, igm, method1="qr",
xformla2=~HEDUC, method2="qr", iters=10, tau1=seq(.05,.95,.05),
tau2=seq(.05,.95,.05))
test.CFA(out$cfa1, Var, igm$lfincome)
}
}
