% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R
\name{cfa2}
\alias{cfa2}
\title{cfa2}
\usage{
cfa2(formla, tvals, yvals, data, xformla1 = NULL, method1 = "dr",
  link1 = "logit", tau1 = seq(0.01, 0.99, 0.01), condDistobj1 = NULL,
  xformla2 = NULL, method2 = "dr", link2 = "logit", tau2 = seq(0.01,
  0.99, 0.01), condDistobj2 = NULL, se = TRUE, iters = 100, cl = 1)
}
\arguments{
\item{formla}{a formula y ~ treatment}

\item{tvals}{the values of the "treatment" to compute parameters of
interest for}

\item{yvals}{the values to compute the counterfactual distribution for}

\item{data}{the data.frame where y, t, and x are}

\item{xformla1}{an optional formula for the first set of x variables}

\item{method1}{the first method for estimating the conditional distribution
it can be "dr" for distribution regression or "qr" for quantile regression}

\item{link1}{if using distribution regression, set the link variable.  It
can be any link function accepted by glm, e.g. logit, probit, cloglog}

\item{tau1}{if using quantile regression, the values of tau to use, the
default is seq(.01,.99,.01)}

\item{condDistobj1}{if have already calculated a conditional distribution
object outside of the model, can set it here}

\item{xformla2}{an optional formula for the second set of x variables}

\item{method2}{the second method for estimating the conditional distribution
it can be "dr" for distribution regression or "qr" for quantile regression}

\item{link2}{if using distribution regression, set the link variable.  It
can be any link function accepted by glm, e.g. logit, probit, cloglog}

\item{tau2}{if using quantile regression, the values of tau to use, the
default is seq(.01,.99,.01)}

\item{condDistobj2}{if have already calculated a conditional distribution
object outside of the model, can set it here}

\item{se}{whether or not to compute standard errors using the bootstrap}

\item{iters}{how many bootstrap iterations to use}

\item{cl}{how many clusters to use for parallel computation of standard
errors}
}
\value{
list of two CFA objects
}
\description{
the same as cfa method except it computes two results at the
 same time which allows one to conduct inference on their difference
}
\examples{
#' data(igm)
tvals <- seq(10,12,length.out=8)
yvals <- seq(quantile(igm$lcfincome, .05), quantile(igm$lcfincome, .95), length.out=50)

## obtain counterfactual results using quantile regression with
## no covariates and adjusting for education
cfa2(lcfincome ~ lfincome, tvals, yvals, igm, method1="qr", xformla2=~HEDUC,
method2="qr", se=FALSE, tau1=seq(.1,.9,.1), tau2=seq(.1,.9,.1))

}
