with_mock_dir("chemical-batch",{
# test_that("catch missing APIs", {
#   #store env variable so tests don't overwrite
#   # tmp <- Sys.getenv("CCTE_API_KEY")
#   # on.exit(Sys.setenv("CCTE_API_KEY" = tmp))
#   # if(Sys.getenv("CCTE_API_KEY") == ""){
#   #   #set env variable temporarily for testing
#   #   Sys.setenv("CCTE_API_KEY" = "stored_api_key")
#   # }
#   # Run register_ccdr(key = 'YOUR KEY', write = TRUE) prior to running tests
#   expect_message(get_chemical_details_batch(DTXSID = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_details_batch(DTXSID = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   # expect_message(get_chemical_by_property_range_batch(), 'Using stored API key!')
#   # expect_message(get_chemical_by_property_range_batch(API_key = 1), 'Using stored API key!')
#   expect_message(get_chem_info_batch(DTXSID = c('DTXSID7020182'), type = 'experimental', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chem_info_batch(DTXSID = c('DTXSID7020182'), type = 'predicted', API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_fate_by_dtxsid_batch(DTXSID = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_fate_by_dtxsid_batch(DTXSID = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_starts_with_batch(word_list = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_starts_with_batch(word_list  = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_equal_batch(word_list = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_equal_batch(word_list = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_contains_batch(word_list = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_contains_batch(word_list = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_mass_batch(start_list = c(1), end_list = c(2), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_mass_batch(start_list = c(1), end_list = c(2), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_formula_batch(formula_list = c('CH4'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_formula_batch(formula_list = c('CH4'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_dtxcid_batch(DTXCID = c('DTXCID30182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_dtxcid_batch(DTXCID = c('DTXCID30182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_lists_by_type_batch(type_list = c('federal'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_lists_by_type_batch(type_list = c('federal'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_public_chemical_list_by_name_batch(name_list = c('BIOSOLIDS2021'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_public_chemical_list_by_name_batch(name_list = c('BIOSOLIDS2021'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_lists_containing_chemical_batch(chemical_list = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_lists_containing_chemical_batch(chemical_list = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemicals_in_list_batch(list_names = c('BIOSOLIDS2021'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemicals_in_list_batch(list_names = c('BIOSOLIDS2021'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_mrv_batch(DTXSID = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_mrv_batch(DTXSID = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_mol_batch(DTXSID = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_mol_batch(DTXSID = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_image_batch(DTXSID = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_image_batch(DTXSID = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_synonym_batch(DTXSID = c('DTXSID7020182'), verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_synonym_batch(DTXSID = c('DTXSID7020182'), API_key = 1, verbose = TRUE), 'Using stored API key!')
# })

test_that("DTXSID/DTXCID errors", {
  expect_error(get_chemical_details_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_details_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_details_batch(DTXCID = 1, API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_chemical_details_batch(DTXCID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_chemical_details_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs or DTXCIDs!')
  expect_error(get_chem_info_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chem_info_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chem_info_batch(API_key = 'test_key', type = 'experimental'), 'Please input a character list for DTXSID!')
  expect_error(get_fate_by_dtxsid_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_fate_by_dtxsid_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_fate_by_dtxsid_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
  expect_error(get_msready_by_dtxcid_batch(DTXCID = 1, API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_msready_by_dtxcid_batch(DTXCID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_msready_by_dtxcid_batch(API_key = 'test_key'), 'Please input a list of DTXCIDs!')
  expect_error(get_chemical_mrv_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_mrv_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_mrv_batch(DTXCID = 1, API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_chemical_mrv_batch(DTXCID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_chemical_mrv_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs or DTXCIDs!')
  expect_error(get_chemical_mol_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_mol_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_mol_batch(DTXCID = 1, API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_chemical_mol_batch(DTXCID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_chemical_mol_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs or DTXCIDs!')
  expect_error(get_chemical_image_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_image_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_image_batch(DTXCID = 1, API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_chemical_image_batch(DTXCID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXCID!')
  expect_error(get_chemical_image_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs or DTXCIDs!')
  expect_error(get_chemical_synonym_batch(DTXSID = 1, API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_synonym_batch(DTXSID = list('first' = '1', 'second' = 2), API_key = 'test_key'), 'Please input a character list for DTXSID!')
  expect_error(get_chemical_synonym_batch(API_key = 'test_key'), 'Please input a list of DTXSIDs!')
})

test_that('Rate limit warnings', {
  expect_warning(get_chemical_details_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_details_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  #expect_warning(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2), property_list = c('Boiling point'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  #expect_warning(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2), property_list = c('Boiling point'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chem_info_batch(DTXSID = c('DTXSID7020182'), type = 8, API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chem_info_batch(DTXSID = c('DTXSID7020182'), type = 8, API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_fate_by_dtxsid_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_fate_by_dtxsid_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(chemical_starts_with_batch(word_list = c('gvfdsr7'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(chemical_starts_with_batch(word_list = c('gvfdsr7'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(chemical_equal_batch(word_list = c('gvfdsr7'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(chemical_equal_batch(word_list = c('gvfdsr7'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(chemical_contains_batch(word_list = c('gvfdsr7'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(chemical_contains_batch(word_list = c('gvfdsr7'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_msready_by_mass_batch(start_list = c(1), end_list = c(1), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_msready_by_mass_batch(start_list = c(1), end_list = c(1), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_msready_by_formula_batch(formula_list = c('CH4'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_msready_by_formula_batch(formula_list = c('CH4'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_msready_by_dtxcid_batch(DTXCID = c('DTXCID30182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_msready_by_dtxcid_batch(DTXCID = c('DTXCID30182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_lists_by_type_batch(type_list = c('federal'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_lists_by_type_batch(type_list = c('federal'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_public_chemical_list_by_name_batch(name_list = c('BIOSOLIDS2021'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_public_chemical_list_by_name_batch(name_list = c('BIOSOLIDS2021'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_lists_containing_chemical_batch(chemical_list = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_lists_containing_chemical_batch(chemical_list = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemicals_in_list_batch(list_names = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemicals_in_list_batch(list_names = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_mrv_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_mrv_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_mol_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_mol_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_image_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_image_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_synonym_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = '0'), 'Setting rate limit to 0 seconds between requests!')
  expect_warning(get_chemical_synonym_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key(), rate_limit = -1), 'Setting rate limit to 0 seconds between requests!')
})

test_that('Numeric range input errors and warnings', {
  expect_error(get_chemical_by_property_range_batch(API_key = ''), 'Please input a list for both `start_list` and `end_list`!')
  expect_error(get_chemical_by_property_range_batch(start_list = c(1), API_key = ''), 'Please input a list for both `start_list` and `end_list`!')
  expect_error(get_chemical_by_property_range_batch(end_list = c(1), API_key = ''), 'Please input a list for both `start_list` and `end_list`!')
  expect_error(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2, 3), API_key = ''), 'Mismatch in length of `start_list` and `end_list`!')
  expect_error(get_chemical_by_property_range_batch(start_list = c(1), end_list = c('2'), API_key = ''), 'Only numeric values allowed in each list!')
  #expect_error(get_chemical_by_property_range_batch(start_list = c(1, 2), end_list = c(2, 3), property_list = c('a'), API_key = ''), 'Setting `property_list` to repeat to match length of `start_list/end_list`!')
  expect_error(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2), property_list = c('1', '2'), API_key = ''), 'Mismatch in length of `property_list` and `start_list/end_list`!')


  expect_error(get_msready_by_mass_batch(API_key = ''), 'Please input a list for both `start_list` and `end_list`!')
  expect_error(get_msready_by_mass_batch(start_list = c(1), API_key = ''), 'Please input a list for both `start_list` and `end_list`!')
  expect_error(get_msready_by_mass_batch(end_list = c(1), API_key = ''), 'Please input a list for both `start_list` and `end_list`!')
  expect_error(get_msready_by_mass_batch(start_list = c(1), end_list = c(2,3), API_key = ''), 'Mismatch in length of `start_list` and `end_list`!')
  expect_error(get_msready_by_mass_batch(start_list = c(4), end_list = c('k'), API_key = ''), 'Only numeric values allowed in `start_list` and `end_list`!')
  expect_error(get_msready_by_mass_batch(start = c('TRUE'), end = c(4), API_key = ''), 'Only numeric values allowed in `start_list` and `end_list`!')
})

test_that('Word search errors', {
  expect_error(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2), API_key = ''), 'Please input a list for `property_list`!')
  expect_error(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2), property_list = c(1), API_key = ''), 'Please input a character list for `property_list`!')
  expect_error(chemical_starts_with_batch(API_key = ''), 'Please input a list of chemical names!')
  expect_error(chemical_starts_with_batch(word_list = c(1), API_key = ''), 'Please input a character list for word_list!')
  expect_error(chemical_equal_batch(API_key = ''), 'Please input a list of chemical names!')
  expect_error(chemical_equal_batch(word_list = c(1), API_key = ''), 'Please input a character list for word_list!')
  expect_error(chemical_contains_batch(API_key = ''), 'Please input a list of chemical names!')
  expect_error(chemical_contains_batch(word_list = 1, API_key = ''), 'Please input a character list for word_list!')
  expect_error(get_msready_by_formula_batch(API_key = ''), 'Please input a list of chemical formulas!')
  expect_error(get_msready_by_formula_batch(formula_list = c(1), API_key = ''), 'Please input a character list for formula_list!')
  expect_error(get_chemical_lists_by_type_batch(API_key = ''), 'Please input a list of list types!')
  expect_error(get_chemical_lists_by_type_batch(type_list = c(1), API_key = ''), 'Please input a character list for type_list!')
  expect_error(get_public_chemical_list_by_name_batch(API_key = ''), 'Please input a list of list names!')
  expect_error(get_public_chemical_list_by_name_batch(name_list = c(1), API_key = ''), 'Please input a character list for name_list!')
  expect_error(get_lists_containing_chemical_batch(API_key = ''), 'Please input a list of DTXSIDs!')
  expect_error(get_lists_containing_chemical_batch(chemical_list = c(1), API_key = ''), 'Please input a character list for chemical_list!')
  expect_error(get_chemicals_in_list_batch(API_key = ''), 'Please input a list of names of chemical lists!')
  expect_error(get_chemicals_in_list_batch(list_name = c(1), API_key = ''), 'Please input a character list for list_names!')
})

test_that('miscellaneous list mismatch warnings', {
  expect_warning(get_chem_info_batch(DTXSID = c('DTXSID7020182', 'DTXSID2021315', 'DTXSID50186350'), type = c('experimental', ''), API_key = ccte_key()), "Setting type to ''!")
  expect_warning(get_chem_info_batch(DTXSID = c('DTXSID7020182'), type = c('predicted', 'experimental'), API_key = ccte_key()), "Setting type to ''!")
})

test_that('Return data types', {
  expect_type(get_chemical_details_batch(DTXSID = 'DTXSID7020182', API_key = ccte_key()), 'list')
  expect_type(get_chemical_details_batch(DTXSID = 'DTXSID7020182', API_key = ccte_key()), 'list')
  expect_type(get_chemical_details_batch(DTXCID = 'DTXCID30182', API_key = ccte_key()), 'list')
  expect_type(get_chemical_details_batch(DTXCID = 'DTXCID30182', Projection = '', API_key = ccte_key()), 'list')
  expect_type(get_chemical_details_batch(DTXSID = '', API_key = ccte_key()), 'list')
  expect_type(get_chemical_details_batch(DTXSID = 'DTXSID7020182', API_key = ''), 'list')
  expect_type(generate_ranges(end = 'p'), 'list')
  expect_type(generate_ranges(end = -1), 'list')
  expect_type(generate_ranges(end = 205), 'list')
  expect_type(generate_dtxsid_string(items = c('DTXSID7020182', 'DTXSID7026185')), 'character')
  expect_type(get_chemical_by_property_range_batch(start_list = c(NA_real_), end_list = (NA_real_), property_list = c('density'), API_key = ccte_key()), 'list')
  #expect_type(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2), property_list = c('Boiling point'), API_key = ccte_key()), 'list')
  #expect_type(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2), property_list = c(''), API_key = ccte_key()), 'list')
  #expect_type(get_chemical_by_property_range_batch(start_list = c(1), end_list = c(2), property_list = c('Boiling point'), API_key = ''), 'list')
  expect_type(get_chem_info_batch(DTXSID = 'DTXSID7020182', type = 'predicted', API_key = ccte_key()), 'list')
  expect_type(get_chem_info_batch(DTXSID = '', type = 'predicted', API_key = ccte_key()), 'list')
  expect_type(get_chem_info_batch(DTXSID = 'DTXSID7020182', type = 'predicted', API_key = ''), 'list')
  expect_type(get_chem_info_batch(DTXSID = 'DTXSID7020182', type = 9, API_key = ''), 'list')
  expect_type(get_fate_by_dtxsid_batch(DTXSID = 'DTXSID7020182', API_key = ccte_key()), 'list')
  expect_type(get_fate_by_dtxsid_batch(DTXSID = '', API_key = ccte_key()), 'list')
  expect_type(get_fate_by_dtxsid_batch(DTXSID = 'DTXSID7020182', API_key = ''), 'list')
  expect_type(chemical_starts_with_batch(word_list = c('DTXSID7020182'), API_key = ccte_key()), 'list')
  expect_type(chemical_starts_with_batch(word_list = c('gvfdsr7'), API_key = ccte_key()), 'list')
  expect_type(chemical_starts_with_batch(word_list = c('DTXSID7020182'), API_key = ''), 'list')
  expect_type(chemical_equal_batch(word_list = c('DTXSID7020182'), API_key = ccte_key()), 'list')
  expect_type(chemical_equal_batch(word_list = c('gvfdsr7'), API_key = ccte_key()), 'list')
  expect_type(chemical_equal_batch(word_list = c('DTXSID7020182'), API_key = ''), 'list')
  expect_type(chemical_contains_batch(word_list = c('DTXSID7020182'), API_key = ccte_key()), 'list')
  expect_type(chemical_contains_batch(word_list = c('gvfdsr7'), API_key = ccte_key()), 'list')
  expect_type(chemical_contains_batch(word_list = c('DTXSID7020182'), API_key = ''), 'list')
  expect_type(get_msready_by_mass_batch(start_list = c(16.0313), end_list = c(16.0314), API_key = ccte_key()), 'list')
  expect_type(get_msready_by_mass_batch(start_list = c(16.0314), end_list = c(16.0314), API_key = ccte_key()), 'list')
  expect_type(get_msready_by_mass_batch(start_list = c(-16.0313), end_list = c(16.0314), API_key = ''), 'list')
  expect_type(get_msready_by_formula_batch(formula_list = c('CH4'), API_key = ccte_key()), 'list')
  expect_type(get_msready_by_formula_batch(formula_list = c('8x'), API_key = ccte_key()), 'list')
  expect_type(get_msready_by_formula_batch(formula_list = c(''), API_key = ccte_key()), 'list')
  expect_type(get_msready_by_formula_batch(formula_list = c('CH4'), API_key = ''), 'list')
  expect_type(get_msready_by_dtxcid_batch(DTXCID = c('DTXCID30182'), API_key = ccte_key()), 'list')
  expect_type(get_msready_by_dtxcid_batch(DTXCID = c(''), API_key = ccte_key()), 'list')
  expect_type(get_msready_by_dtxcid_batch(DTXCID = c('DTXCID30182'), API_key = ''), 'list')
  expect_type(get_chemical_lists_by_type_batch(type = c('federal'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_lists_by_type_batch(type = c(''), API_key = ccte_key()), 'list')
  expect_type(get_chemical_lists_by_type_batch(type = c('federal'), API_key = ''), 'list')
  expect_type(get_public_chemical_list_by_name_batch(name_list = c('BIOSOLIDS2021'), API_key = ccte_key()), 'list')
  expect_type(get_public_chemical_list_by_name_batch(name_list = c(''), API_key = ccte_key()), 'list')
  expect_type(get_public_chemical_list_by_name_batch(name_list = c('BIOSOLIDS2021'), API_key = ''), 'list')
  expect_type(get_lists_containing_chemical_batch(chemical_list = c('DTXSID7020182'), API_key = ccte_key()), 'list')
  expect_type(get_lists_containing_chemical_batch(chemical_list = c(''), API_key = ccte_key()), 'list')
  expect_type(get_lists_containing_chemical_batch(chemical_list = c('DTXSID7020182'), API_key = ''), 'list')
  expect_type(get_chemicals_in_list_batch(list_names = c('BIOSOLDIS2021'), API_key = ccte_key()), 'list')
  expect_type(get_chemicals_in_list_batch(list_names = c(''), API_key = ccte_key()), 'list')
  expect_type(get_chemicals_in_list_batch(list_names = c('BIOSOLDIS2021'), API_key = ''), 'list')
  expect_type(get_chemical_mrv_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_mrv_batch(DTXCID = c('DTXCID30182'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_mrv_batch(DTXSID = c(''), API_key = ccte_key()), 'list')
  expect_type(get_chemical_mrv_batch(DTXSID = c('DTXSID7020182'), API_key = ''), 'list')
  expect_type(get_chemical_mrv_batch(DTXCID = c('DTXCID30182'), API_key = ''), 'list')
  expect_type(get_chemical_mol_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_mol_batch(DTXCID = c('DTXCID30182'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_mol_batch(DTXSID = c(''), API_key = ccte_key()), 'list')
  expect_type(get_chemical_mol_batch(DTXSID = c('DTXSID7020182'), API_key = ''), 'list')
  expect_type(get_chemical_mol_batch(DTXCID = c('DTXCID30182'), API_key = ''), 'list')
  expect_type(get_chemical_image_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_image_batch(DTXCID = c('DTXCID30182'), format = c('png'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_image_batch(DTXSID = c(''), format = c('svg'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_image_batch(DTXSID = c('DTXSID7020182'), API_key = ''), 'list')
  expect_type(get_chemical_image_batch(DTXCID = c('DTXCID30182'), format = c('png'), API_key = ''), 'list')
  expect_type(get_chemical_synonym_batch(DTXSID = c('DTXSID7020182'), API_key = ccte_key()), 'list')
  expect_type(get_chemical_synonym_batch(DTXSID = c(''), API_key = ccte_key()), 'list')
  expect_type(get_chemical_synonym_batch(DTXSID = c('DTXSID7020182'), API_key = ''), 'list')
  })
})
