% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chemical_image}
\alias{get_chemical_image}
\title{Get image file by DTXSID or DTXCID}
\usage{
get_chemical_image(
  DTXSID = NULL,
  DTXCID = NULL,
  format = "",
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{Chemical identifier DTXSID}

\item{DTXCID}{Chemical identifier DTXCID}

\item{format}{The image type, either "png" or "svg". If left blank, will
default to "png".}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A Large array of three dimensions representing an image. For
displaying this, one may use \code{png::writePNG()} or
\code{countcolors::plotArrayAsImage()} among many such functions.
}
\description{
Get image file by DTXSID or DTXCID
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical image for BPA by dtxsid
bpa_image_matrix <- get_chemical_image(DTXSID = 'DTXSID7020182')
if (requireNamespace("countcolors", quietly = TRUE)){
  countcolors::plotArrayAsImage(bpa_image_matrix)
}
# Pull chemical image for BPA by dtxcid
bpa_image_matrix <- get_chemical_image(DTXCID = 'DTXCID30182')
if (requireNamespace("countcolors", quietly = TRUE)){
  countcolors::plotArrayAsImage(bpa_image_matrix)
}
\dontshow{\}) # examplesIf}
}
