% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boottestgscm.r
\name{boottestgscm}
\alias{boottestgscm}
\title{Testing two segmentations of a GSC model}
\usage{
boottestgscm(dat, B, indicatorx, indicatory, loadingx = FALSE,
  loadingy = FALSE, member1, member2, alpha, inner = FALSE)
}
\arguments{
\item{dat}{(n,p)-matrix, the values of the manifest variables.
The columns must be arranged in that way that the components of refl are (absolutely) increasing.}

\item{B}{(q,q) lower triangular matrix describing the interrelations of the latent variables:
b_ij = 1 regression coefficient of eta_j in the regression relation in which eta_i is the depend variable 
b_ij = 0 if eta_i does not depend on eta_j in a direct way  (b_ii = 0 !)}

\item{indicatorx}{vector describing with which exogenous composite the X-variables are connected}

\item{indicatory}{vector describing with which endogenous composite the Y-variables are connected}

\item{loadingx}{logical FALSE when there are no loadings for the X-variables in the model}

\item{loadingy}{logical FALSE when there are no loadings for the Y-variables in the model}

\item{member1}{vector of length n, indicating the cluster the observation belongs to for the first clustering}

\item{member2}{vector of length n, indicating the cluster the observation belongs to for the second clustering}

\item{alpha}{scalar, significance level ( = 1 - confidence level )}

\item{inner}{Boolean, should a inner bootstrap loop be computed?}
}
\value{
KI vector with the confidence bounds; positive lower limit indicates significant superiority of first
        clustering, negative upper limit of  second clustering.
}
\description{
\code{boottestgscm} computes a confidence interval for the difference of weighted average of averages of coefficients of determination 
for two segmentations of a  GSC model 
For a one sided alternative hypothesis the error alpha has to be duplicated
}
\examples{
\donttest{ 
  data(twoclm)
  member1 <- c(rep(1,50),rep(2,50))
  member2 <- twoclm[,10]
  dat <- twoclm[,-10]
  B <- matrix(c( 0,0,0, 0,0,0, 1,1,0),3,3,byrow=TRUE)
  indicatorx <- c(1,1,1,2,2,2)
  indicatory <- c(1,1,1)   
  boottestgscm(dat,B,indicatorx,indicatory,loadingx=FALSE,loadingy=FALSE,
               member2,member1,0.1,inner=FALSE)
}
}
