% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_make_DAG.R
\name{eval_make_DAG}
\alias{eval_make_DAG}
\title{Evaluates and Makes Formula for regression of exposure or risk factor or outcome on its parents in a causal Bayesian network directed acyclic graph.}
\usage{
eval_make_DAG(
  data,
  regressionExposure,
  regressionMediator,
  response,
  response_model_mediators,
  response_model_exposure,
  w
)
}
\arguments{
\item{data}{A wide format data containing all the risk factors, confounders, exposures and outcomes within the causal DAG Bayesian network.}

\item{regressionExposure}{Regression of response given exposure based on adjustment set output from function make_DAG.R.}

\item{regressionMediator}{Regression of response given exposure (mediator as exposure) based on canonical adjustment set output from function make_DAG.R.}

\item{response}{The name of the response column variable within dataframe in text format e.g. "case". The cases should be coded as 1 and the controls as 0.}

\item{response_model_mediators}{A model fitted for the response in a causal Bayesian network excluding ``children'' of the mediators in the causal Bayesian network. See example in tutorial.}

\item{response_model_exposure}{A model fitted for the response in a causal Bayesian network excluding ``children'' of the exposure and risk factors in the causal Bayesian network. See example in tutorial.}

\item{w}{Column of weights for case control matching listing in same order as patients in data.}
}
\value{
\itemize{
\item{regressionExposure_listReturn }{model list regressionExposure_listReturn}
\item{regressionMediator_listReturn }{model list regressionMediator_listReturn}
}
}
\description{
Evaluates and Makes Formula for regression of exposure or risk factor or outcome on its parents in a causal Bayesian network directed acyclic graph. Given a causal Bayesian network, directed acyclic graph (DAG) where arrows representing
causal dependencies between confounders, risk factors/exposure and disease, together with a sensible probability distribution on
the graph that respects these causal dependencies. To consistently estimate causal effects that risk factors may have on each
other and on disease, we need to make a strong no unmeasured confounding assumption: that is common causes of nodes in the graph,
which may be causes of two risk factors or a cause of risk factor and disease, are also included as nodes in the graph.
Causal Bayesian networks have a local Markov property that the conditional probability distribution of any node Xj, given values
for the other variables in the network, only depends on the values $x_{pa}_{j}$ of the parent nodes.
}
\keyword{internal}
