% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_sim_sequentialPAF.R
\name{do_sim_sequentialPAF}
\alias{do_sim_sequentialPAF}
\title{Simulates a Fitted Model for a Mediator or Exposure or Risk Factor Allowing for Potential Outcomes in Causal Analysis}
\usage{
do_sim_sequentialPAF(colnum, current_mat, model)
}
\arguments{
\item{colnum}{Column number of exposure or risk factor of interest within the data frame. The data frame has cases in rows and variables in columns.}

\item{current_mat}{The data frame containing the data for which the model can be simulated with. For
potential outcomes for example such as \eqn{Y_{A=0,M_{1},M_{2},M_{3}}} requires the exposure in this case
to be pre set to zero i.e. \code{current_mat} should have the exposure \eqn{Y_{A=0}} set to zero if simulating
e.g. \eqn{M_{1}}.}

\item{model}{A fitted causal regression model for either a binary, continuous or an ordered factor response.}
}
\value{
\item{simulation }{simulation}
}
\description{
A fitted model for a mediator or exposure or risk factor can be simulated given values of the other risk
factors or exposure saved in the data frame \code{current_mat}. This allows for potential outcomes to be measured for
causal analysis. For example, for an outcome \eqn{Y_{A,M}} with exposure A and mediators \eqn{M_{1}, M_{3}, \dots M_{K}}
the function can measure potential outcomes such as \eqn{Y_{A=0,M_{1},M_{2},M_{3}}} or \eqn{Y_{A=0,M_{1},M_{2}=0,M_{3}=0}} when there are three mediators.
The model can be either a binary, continuous or an ordered factor response model.
}
\examples{
\dontrun{
# I don't want you to run this
}
}
\keyword{internal}
