% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESS.R
\docType{methods}
\name{ESS}
\alias{ESS}
\alias{ESS,numeric-method}
\alias{ESS,causalWeights-method}
\title{Effective Sample Size}
\usage{
ESS(x)

\S4method{ESS}{numeric}(x)

\S4method{ESS}{causalWeights}(x)
}
\arguments{
\item{x}{Either a vector of weights summing to 1 or an object of class
\link[=causalWeights-class]{causalWeights}}
}
\value{
Either a number denoting the effective sample size or if \code{x} is of class
\link[=causalWeights-class]{causalWeights}, then returns a list of both values in the treatment
and control groups.
}
\description{
Effective Sample Size
}
\details{
Calculates the effective sample size as described by Kish (1965).
However, this calculation has some problems and the \code{\link[=PSIS]{PSIS()}}
function should be used instead.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: default ESS method for numeric vectors

\item \code{causalWeights}: ESS method for objects of class \link[=causalWeights-class]{causalWeights}
}}

\examples{
x <- rep(1/100,100)
ESS(x)
}
\seealso{
\link[=PSIS]{PSIS()}
}
