% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{list_databases}
\alias{list_databases}
\title{List Databases}
\usage{
list_databases(sc)
}
\arguments{
\item{sc}{A \code{spark_connection}.}
}
\value{
A \code{tibble} containing 3 columns:
\itemize{
\item \code{name} - The name of the database.
\item \code{description} - Description of the database.
\item \code{locationUri} - Path (in the form of a uri) to data files.
}
}
\description{
Returns a list of databases available across all sessions. The result
contains the name, description and locationUri of each database.
}
\examples{
\dontrun{
sc <- sparklyr::spark_connect(master = "local")
list_databases(sc = sc)
}

}
\seealso{
\code{\link[=current_database]{current_database()}}, \code{\link[=database_exists]{database_exists()}}, \code{\link[=set_current_database]{set_current_database()}}
}
