% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nfc_cat}
\alias{nfc_cat}
\title{Need for Cognition Cat Object}
\format{An object of class \code{Cat} of length 1.}
\source{
See \url{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.

See \url{https://wc.wustl.edu/american-panel-survey} for raw TAPS data.
}
\usage{
data(nfc_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 34 item Need for Cognition inventory
}
\details{
Cat object containing item parameters for graded response model fit with 4985 response profiles collected by Qualtrics in June 2018
and 1512 response profiles from The American Panel Survey (TAPS) in December 2014.
TAPS is a monthly online panel survey  of about 2,000 adults in the United States. The panel was recruited in the fall of 2011 using an address-based sampling frame.  TAPS surveys are administered online.  Selected panelists who do not have a computer or online service are provided a computer and internet access by TAPS. 

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the TAPS sample (.003) and a standard deviation (1.6)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are:

5 = Strongly agree, 4 = Somewhat agree, 3 = Neither agree nor disagree, 2 = Somewhat disagree, 1 = Strongly disagree

The wording of the question items is: 

\describe{
\item{\code{q1}}{	I would prefer complex to simple problems.}  
\item{\code{q2}}{	I don't like to have the responsibility for handling a situation that requires a lot of thinking.}
\item{\code{q3}}{	Thinking is not my idea of fun.} 
\item{\code{q4}}{    	I would rather do something that requires little thought than something that is sure to challenge my thinking abilities.} 
\item{\code{q5}}{	I try to anticipate and avoid situations where there is a likely chance I will have to think in depth about something.} 
\item{\code{q6}}{	 	I find little satisfaction in deliberating hard and for long hours.}
\item{\code{q7}}{	 	I only think as hard as I have to.}
\item{\code{q8}}{	 	I prefer to think about small, daily projects more than long-term ones.} 
\item{\code{q9}}{	 	I like tasks that require little thought once I've learned them.}  
\item{\code{q10}}{	 	The idea of relying on thought to make my way to the top does not appeal to me.}
\item{\code{q11}}{	 	I really enjoy a task that involves coming up with new solutions to problems.}
\item{\code{q12}}{	 	Learning new ways to think doesn't excite me very much.}  
\item{\code{q13}}{	I prefer my life to be filled with puzzles that I must solve.}  
\item{\code{q14}}{	 	The notion of thinking abstractly is not appealing to me.}
\item{\code{q15}}{	 	I would prefer a task that is intellectual, difficult, and important to one that is somewhat important but does not require much thought.} 
\item{\code{q16}}{	I feel relief rather the satisfaction after completing a task that required a lot of mental effort.}
\item{\code{q17}}{	Its enough for me that something gets the job done, I don't care how or why it works.} 
\item{\code{q18}}{	 	I usually end up deliberating about issues even when they do not affect me personally.}  
\item{\code{q19}}{	 	I tend to set goals that can be accomplished only by expending considerable mental effort.} 
\item{\code{q20}}{  	I am usually tempted to put more thought into a task than the job minimally requires.} 
\item{\code{q21}}{  	I am hesitant about making important decisions after thinking about them.} 
\item{\code{q22}}{  	I prefer just to let things happen rather than try to understand why they turned out that way.} 
\item{\code{q23}}{  	I have difficulty thinking in new and unfamiliar situations.} 
\item{\code{q24}}{  	I am an intellectual.} 
\item{\code{q25}}{  	I don't reason well under pressure.} 
\item{\code{q26}}{  	I more often talk with other people about the reasons/possible solutions to international problems than about gossip or tidbits about what famous people are doing.} 
\item{\code{q27}}{ These days, I see little chance for performing well, even in intellectual jobs, unless one knows the right people.}
\item{\code{q28}}{ More often than not, more thinking just leads to more errors.} 
\item{\code{q29}}{ I appreciate opportunities to discover the strengths and weaknesses of my own reasoning.} 
\item{\code{q30}}{ I prefer watching educational programs more than entertainment programs.} 
\item{\code{q31}}{ I think best when those around me are very intelligent.}
\item{\code{q32}}{ Simply knowing the answer rather than understanding the reasons for the answer to a problem is fine with me.} 
\item{\code{q33}}{ Ignorance is bliss.} 
\item{\code{q34}}{ I enjoy thinking about an issue even when the results of my thought will have no effect on the outcome of the issue.} 
}
}
\references{
Cacioppo, John T., and Richard E. Petty. "The need for cognition."
 Journal of personality and social psychology 42.1 (1982): 116.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
