% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{cat_apply_freq}
\alias{cat_apply_freq}
\title{Applying frequencies to the object returned by the `get_mappings` function}
\usage{
cat_apply_freq(to_x, freqs)
}
\arguments{
\item{to_x}{`list` object returned by `get_mappings`.}

\item{freqs}{`data.frame` object like the one returned by
the `get_freqs` function.}
}
\value{
a `list` with a structure like `to_x` object but with probabilities
for each category.
}
\description{
applying frequencies to the object returned by
the `get_mappings` function.
We will get a symmetric object to the one returned by
the `get_mappings` function, nevertheless categories are replaced
with frequencies.
Frequencies for each category/key are sum to 1, so could be interpreted
as probabilities.
}
\note{
`freqs` arg first column (keys) and the to_x arg values have to be of
the same type.
The uniform distribution (outcomes are equally likely) is assumed
for no match for all possible categories.
}
\examples{
data("trans", package = "cat2cat")
data("occup", package = "cat2cat")

mappings <- get_mappings(trans)

mappings$to_old[1:4]
mappings$to_new[1:4]

mapp_p <- cat_apply_freq(
  mappings$to_old,
  get_freqs(
    occup$code[occup$year == "2008"],
    occup$multiplier[occup$year == "2008"]
  )
)
head(data.frame(I(mappings$to_old), I(mapp_p)))
mapp_p <- cat_apply_freq(
  mappings$to_new,
  get_freqs(
    occup$code[occup$year == "2010"],
    occup$multiplier[occup$year == "2010"]
  )
)
head(data.frame(I(mappings$to_new), I(mapp_p)))
}
