% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/float.R
\name{float}
\alias{float}
\title{Floats}
\usage{
float(x, side)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{side}{A \link{responsive} argument.

One of \code{"left"}, \code{"left"}, \code{"right"}, \code{"right"}, or \code{"none"} specifying the side to float the element.}
}
\description{
The \code{float()} function places an element to the left or right side of its
parent element. Other text and inline elements wrap around floated elements.
Note, \code{float()} has no effect on flex items.
}
\examples{

library(htmltools)

div(
  div(
    .style \%>\%
      border("red") \%>\%
      float("left"),
    "Warning"
  ),
  div(
    "Nam a sapien.",
    "Phasellus neque orci, porta a, aliquet quis, semper a, massa.",
    "Phasellus lacus."
  )
)

}
