% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legendWaffle.R
\name{legendWaffle}
\alias{legendWaffle}
\title{Legend for Typology Maps}
\usage{
legendWaffle(
  pos = "topleft",
  title.txt = "Title of the legend",
  title.cex = 0.8,
  values.cex = 0.6,
  categ,
  cex = 1,
  cell.txt = "1 cell = ...",
  col,
  cell.size,
  border = "white",
  lwd = 0.2,
  frame = FALSE
)
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", 
"bottomleftextra", "left" or a vector of two coordinates in map units 
(c(x, y)).}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{values.cex}{size of the values in the legend.}

\item{categ}{vector of categories.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{cell.txt}{label for cell values.}

\item{col}{a vector of colors.}

\item{cell.size}{size of the cell}

\item{border}{color of the cells borders.}

\item{lwd}{width of the cells borders}

\item{frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}
}
\description{
Plot legend for typology maps.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
plot(st_geometry(mtq))
box()

# Define labels and colors
someLabels <- c("red color", "yellow color", "green color", "black color")
someColors <- c("red", "yellow", "green", "black")
legendWaffle(categ = someLabels, col = someColors, cell.size = 750)
}
