% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tilesLayer.R
\name{tilesLayer}
\alias{tilesLayer}
\title{Plot Tiles from Open Map Servers}
\usage{
tilesLayer(x, add = FALSE)
}
\arguments{
\item{x}{a RasterBrick object; the \link{getTiles} function outputs these 
objects.}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot tiles from open map servers.
}
\note{
This function is a wrapper for plotRGB from the 
raster package.
}
\examples{
\dontrun{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# Download the tiles, extent = Martinique
mtqOSM <- getTiles(x = mtq, type = "osm", crop = TRUE)
# Plot the tiles
tilesLayer(mtqOSM)
# Plot countries
plot(st_geometry(mtq), add=TRUE)
txt <- "© OpenStreetMap contributors. Tiles style under CC BY-SA, www.openstreetmap.org/copyright"
mtext(text = txt, side = 1, adj = 0, cex = 0.7, font = 3)
}
}
\seealso{
\link{getTiles}
}
