% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/north.R
\name{north}
\alias{north}
\title{North Arrow}
\usage{
north(pos = "topright", col = "grey20", south = FALSE)
}
\arguments{
\item{pos}{position of the north arrow. It can be one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates (c(x, y)).}

\item{col}{arrow color.}

\item{south}{plot a south arrow instead.}
}
\description{
Plot a north arrow.
}
\examples{
data("nuts2006")
plot(nuts0.spdf, col = "grey60",border = "grey20", add=FALSE)
box()
for (i in list("topleft", "top", "topright", "right", "bottomright", 
               "bottom", "bottomleft", "left", c(3502127, 4770427))){
  north(i)
}

plot(nuts0.spdf)
box()
for (i in list("topleft", "top", "topright", "right", "bottomright", 
               "bottom", "bottomleft", "left", c(3502127, 4770427))){
  north(i, south = TRUE)
}
}
\seealso{
\link{layoutLayer}
}
